/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position.functions;

import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByCurrency;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.event.position.functions.InterpolateForwardRate;
import cdm.product.template.ForwardPayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=FxMarkToMarketDefault.class)
public abstract class FxMarkToMarket
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected FilterQuantityByCurrency filterQuantityByCurrency;
    @Inject
    protected InterpolateForwardRate interpolateForwardRate;

    public BigDecimal evaluate(Trade trade) {
        this.conditionValidator.validate(() -> ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout())), "The forwardPayout on the contract must exist.");
        BigDecimal value = this.doEvaluate(trade);
        return value;
    }

    protected abstract BigDecimal doEvaluate(Trade var1);

    protected abstract MapperS<? extends ForwardPayout> forwardPayout(Trade var1);

    protected abstract MapperS<? extends FieldWithMetaString> quotedCurrency(Trade var1);

    protected abstract MapperS<? extends FieldWithMetaString> baseCurrency(Trade var1);

    protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantities(Trade var1);

    protected abstract MapperS<BigDecimal> quotedQuantity(Trade var1);

    protected abstract MapperS<BigDecimal> baseQuantity(Trade var1);

    protected abstract MapperS<BigDecimal> interpolatedRate(Trade var1);

    public static class FxMarkToMarketDefault
    extends FxMarkToMarket {
        @Override
        protected BigDecimal doEvaluate(Trade trade) {
            BigDecimal value = null;
            return this.assignOutput(value, trade);
        }

        protected BigDecimal assignOutput(BigDecimal value, Trade trade) {
            value = (BigDecimal)MapperMaths.multiply((Mapper)MapperMaths.subtract((Mapper)MapperMaths.divide(this.quotedQuantity(trade), this.interpolatedRate(trade)), this.baseQuantity(trade)), this.interpolatedRate(trade)).get();
            return value;
        }

        @Override
        protected MapperS<? extends ForwardPayout> forwardPayout(Trade trade) {
            return MapperS.of((Object)((ForwardPayout)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()));
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> quotedCurrency(Trade trade) {
            return MapperS.of((Object)((FieldWithMetaString)ExpressionOperatorsNullSafe.distinct((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get()));
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> baseCurrency(Trade trade) {
            return MapperS.of((Object)((FieldWithMetaString)ExpressionOperatorsNullSafe.distinct((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency())).get()));
        }

        @Override
        protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantities(Trade trade) {
            return MapperS.of((Object)((TradeLot)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity());
        }

        @Override
        protected MapperS<BigDecimal> quotedQuantity(Trade trade) {
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)this.quotedCurrency(trade).get();
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByCurrency.evaluate(this.quantities(trade).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), fieldWithMetaString == null ? null : fieldWithMetaString.getValue())).get())).map("getValue", quantitySchedule -> quantitySchedule.getValue());
        }

        @Override
        protected MapperS<BigDecimal> baseQuantity(Trade trade) {
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)this.baseCurrency(trade).get();
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByCurrency.evaluate(this.quantities(trade).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).getMulti(), fieldWithMetaString == null ? null : fieldWithMetaString.getValue())).get())).map("getValue", quantitySchedule -> quantitySchedule.getValue());
        }

        @Override
        protected MapperS<BigDecimal> interpolatedRate(Trade trade) {
            return MapperS.of((Object)this.interpolateForwardRate.evaluate((ForwardPayout)this.forwardPayout(trade).get()));
        }
    }
}

