/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.base.datetime.functions.GenerateDateList;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GenerateObservationDatesDefault.class)
public abstract class GenerateObservationDates
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected GenerateDateList generateDateList;

    public List<Date> evaluate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
        List<Date> observationDates = this.doEvaluate(observationPeriod, businessCenters, lockoutDays);
        return observationDates;
    }

    protected abstract List<Date> doEvaluate(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    protected abstract MapperS<Integer> days(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    protected abstract MapperS<Date> endDate(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    public static class GenerateObservationDatesDefault
    extends GenerateObservationDates {
        @Override
        protected List<Date> doEvaluate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
            if (businessCenters == null) {
                businessCenters = Collections.emptyList();
            }
            ArrayList<Date> observationDates = new ArrayList<Date>();
            return this.assignOutput(observationDates, observationPeriod, businessCenters, lockoutDays);
        }

        protected List<Date> assignOutput(List<Date> observationDates, CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
            observationDates.addAll(this.generateDateList.evaluate((Date)MapperS.of((Object)observationPeriod).map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate()).get(), (Date)this.endDate(observationPeriod, businessCenters, lockoutDays).get(), businessCenters));
            return observationDates;
        }

        @Override
        protected MapperS<Integer> days(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
            MapperS ifThenElseResult = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)lockoutDays)).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)lockoutDays) : MapperS.of((Object)0);
            return MapperMaths.add((Mapper)MapperS.of((Object)1), (Mapper)ifThenElseResult);
        }

        @Override
        protected MapperS<Date> endDate(CalculationPeriodBase observationPeriod, List<BusinessCenterEnum> businessCenters, Integer lockoutDays) {
            return MapperS.of((Object)this.addBusinessDays.evaluate((Date)MapperS.of((Object)observationPeriod).map("getAdjustedEndDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedEndDate()).get(), (Integer)MapperMaths.multiply((Mapper)MapperS.of((Object)-1), this.days(observationPeriod, businessCenters, lockoutDays)).get(), businessCenters));
        }
    }
}

