/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.processor;

import cdm.base.datetime.PeriodEnum;
import cdm.base.math.DatedValue;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommoditySchedulesMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommoditySchedulesMappingProcessor.class);

    public CommoditySchedulesMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        Path scheduleSynonymPath = synonymPath.getParent();
        List<Mapping> calculationPeriodHrefMappings = this.findMappings(scheduleSynonymPath, "calculationPeriods", "href");
        if (calculationPeriodHrefMappings.isEmpty()) {
            return;
        }
        Path productSynonymPath = scheduleSynonymPath.getParent();
        LocalDate effectiveDate = this.extractLocalDate(productSynonymPath, ".effectiveDate.adjustableDate.unadjustedDate");
        LocalDate terminationDate = this.extractLocalDate(productSynonymPath, ".terminationDate.adjustableDate.unadjustedDate");
        if (effectiveDate == null || terminationDate == null) {
            return;
        }
        List<? extends RosettaModelObjectBuilder> datedValueBuilders = builders;
        for (Mapping calculationPeriodHrefMapping : calculationPeriodHrefMappings) {
            String id = (String)calculationPeriodHrefMapping.getXmlValue();
            Optional<Mapping> calculationPeriodsScheduleIdMapping = this.findMapping("calculationPeriodsSchedule.id", id);
            calculationPeriodsScheduleIdMapping.ifPresent(mapping -> {
                Path parentPath = mapping.getXmlPath().getParent();
                this.mapCalculationPeriodsSchedule(datedValueBuilders, effectiveDate, terminationDate, parentPath);
                MappingProcessorUtils.updateMappingSuccess((Mapping)calculationPeriodHrefMapping, (RosettaPath)this.getModelPath());
                MappingProcessorUtils.updateMappingSuccess((Mapping)mapping, (RosettaPath)this.getModelPath());
            });
            Optional<Mapping> calculationPeriodsIdMapping = this.findMapping("calculationPeriods.id", id);
            calculationPeriodsIdMapping.ifPresent(mapping -> {
                Path parentPath = mapping.getXmlPath().getParent();
                this.mapCalculationPeriods(datedValueBuilders, terminationDate, parentPath);
                MappingProcessorUtils.updateMappingSuccess((Mapping)calculationPeriodHrefMapping, (RosettaPath)this.getModelPath());
                MappingProcessorUtils.updateMappingSuccess((Mapping)mapping, (RosettaPath)this.getModelPath());
            });
        }
    }

    private void mapCalculationPeriodsSchedule(List<DatedValue.DatedValueBuilder> datedValueBuilders, LocalDate effectiveDate, LocalDate terminationDate, Path calculationPeriodsSchedulePath) {
        List<Mapping> calculationPeriodsScheduleMappings = this.getMappings().stream().filter(m -> calculationPeriodsSchedulePath.nameStartMatches(m.getXmlPath())).filter(m -> m.getXmlValue() != null).collect(Collectors.toList());
        Mapping periodMapping = CommoditySchedulesMappingProcessor.filterMappings(calculationPeriodsScheduleMappings, "period");
        PeriodEnum period = this.extractPeriodEnum(periodMapping);
        Mapping periodMultiplierMapping = CommoditySchedulesMappingProcessor.filterMappings(calculationPeriodsScheduleMappings, "periodMultiplier");
        Integer periodMultiplier = this.extractInteger(periodMultiplierMapping);
        if (period == null || periodMultiplier == null) {
            return;
        }
        Mapping balanceOfFirstPeriodMapping = CommoditySchedulesMappingProcessor.filterMappings(calculationPeriodsScheduleMappings, "balanceOfFirstPeriod");
        boolean balanceOfFirstPeriod = this.extractBoolean(balanceOfFirstPeriodMapping);
        int index = 0;
        this.setDatedValue(datedValueBuilders, index, effectiveDate);
        LocalDate currentDate = effectiveDate;
        while (currentDate.isBefore(terminationDate)) {
            ++index;
            if (!(currentDate = this.getNextPeriodStartDate(period, currentDate, periodMultiplier, balanceOfFirstPeriod)).isBefore(terminationDate)) continue;
            this.setDatedValue(datedValueBuilders, index, currentDate);
        }
    }

    private LocalDate getNextPeriodStartDate(PeriodEnum period, LocalDate date, int periodMultiplier, boolean balanceOfFirstPeriod) {
        switch (period) {
            case M: {
                if (balanceOfFirstPeriod) {
                    return date.plusMonths(periodMultiplier).withDayOfMonth(1);
                }
                return date.plusMonths(periodMultiplier);
            }
            case D: {
                return date.plusDays(periodMultiplier);
            }
            case W: {
                return date.plusWeeks(periodMultiplier);
            }
            case Y: {
                return date.plusYears(periodMultiplier);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown period %s", new Object[]{period}));
    }

    private void mapCalculationPeriods(List<DatedValue.DatedValueBuilder> datedValueBuilders, LocalDate terminationDate, Path calculationPeriodsPath) {
        Optional<Mapping> calculationPeriodDateMapping;
        LocalDate calculationPeriodDate;
        for (int index = 0; index < datedValueBuilders.size() && (calculationPeriodDate = (LocalDate)(calculationPeriodDateMapping = this.findMapping(calculationPeriodsPath, "unadjustedDate", index)).map(Mapping::getXmlValue).map(this::parseLocalDate).orElse(null)) != null && !calculationPeriodDate.isAfter(terminationDate); ++index) {
            this.setDatedValue(datedValueBuilders, index, calculationPeriodDate);
            MappingProcessorUtils.updateMappingSuccess((Mapping)calculationPeriodDateMapping.get(), (RosettaPath)this.getModelPath());
        }
    }

    private void setDatedValue(List<DatedValue.DatedValueBuilder> datedValues, int index, LocalDate date) {
        Optional.ofNullable(datedValues.get(index)).ifPresent(datedValueBuilder -> datedValueBuilder.setDate(Date.of((LocalDate)date)));
    }

    private PeriodEnum extractPeriodEnum(Mapping m) {
        return Optional.ofNullable(m).map(Mapping::getXmlValue).map(String.class::cast).map(this::parsePeriodEnum).orElse(null);
    }

    private PeriodEnum parsePeriodEnum(String s) {
        try {
            return PeriodEnum.valueOf(s);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse PeriodEnum {}", (Object)s, (Object)e);
            return null;
        }
    }

    private Integer extractInteger(Mapping m) {
        return Optional.ofNullable(m).map(Mapping::getXmlValue).map(String.class::cast).map(Integer::parseInt).orElse(null);
    }

    private Boolean extractBoolean(Mapping m) {
        return Optional.ofNullable(m).map(Mapping::getXmlValue).map(String.class::cast).map(Boolean::parseBoolean).orElse(false);
    }

    private LocalDate extractLocalDate(Path startsWithPath, String xmlPathContains) {
        return this.getMappings().stream().filter(m -> startsWithPath.nameStartMatches(m.getXmlPath())).filter(mapping -> mapping.getXmlPath().toString().contains(xmlPathContains)).map(Mapping::getXmlValue).filter(Objects::nonNull).map(this::parseLocalDate).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private LocalDate parseLocalDate(Object o) {
        try {
            return LocalDate.parse((String)o);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse local date {}", o, (Object)e);
            return null;
        }
    }

    private List<Mapping> findMappings(Path startsWithPath, String pathContains, String pathEndsWith) {
        return this.getMappings().stream().filter(m -> startsWithPath.nameStartMatches(m.getXmlPath())).filter(m -> m.getXmlPath().toString().contains(pathContains)).filter(m -> m.getXmlPath().endsWith(new String[]{pathEndsWith})).filter(m -> m.getXmlValue() != null).collect(Collectors.toList());
    }

    private static Mapping filterMappings(List<Mapping> mappings, String pathEndsWith) {
        return mappings.stream().filter(m -> m.getXmlPath().endsWith(new String[]{pathEndsWith})).filter(m -> m.getXmlValue() != null).findFirst().orElse(null);
    }

    private Optional<Mapping> findMapping(String xmlPathContains, String xmlValue) {
        return this.getMappings().stream().filter(m -> m.getXmlPath().toString().contains(xmlPathContains)).filter(m -> xmlValue.equals(m.getXmlValue())).findFirst();
    }

    private Optional<Mapping> findMapping(Path pathStartsWith, String pathEndsWith, int pathIndex) {
        return this.getMappings().stream().filter(m -> pathStartsWith.nameStartMatches(m.getXmlPath())).filter(m -> m.getXmlPath().endsWith(new String[]{pathEndsWith})).filter(m -> m.getXmlPath().getLastElement().forceGetIndex() == pathIndex).filter(m -> m.getXmlValue() != null).findFirst();
    }
}

