/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceScheduleCashPrice")
@ImplementedBy(value=Default.class)
public interface PriceScheduleCashPrice
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceScheduleCashPrice";
    public static final String DEFINITION = "if cashPrice exists then priceType = PriceTypeEnum -> CashPrice";

    public static class NoOp
    implements PriceScheduleCashPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceScheduleCashPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceScheduleCashPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleCashPrice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceScheduleCashPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleCashPrice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)priceSchedule).map("getCashPrice", _priceSchedule -> _priceSchedule.getCashPrice())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.CASH_PRICE)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

