/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceScheduleUnitOfAmountExists")
@ImplementedBy(value=Default.class)
public interface PriceScheduleUnitOfAmountExists
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceScheduleUnitOfAmountExists";
    public static final String DEFINITION = "if priceType = PriceTypeEnum -> Variance or priceType = PriceTypeEnum -> Volatility or priceType = PriceTypeEnum -> Correlation then unit is absent and perUnitOf is absent else unit exists and perUnitOf exists";

    public static class NoOp
    implements PriceScheduleUnitOfAmountExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceScheduleUnitOfAmountExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceScheduleUnitOfAmountExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleUnitOfAmountExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceScheduleUnitOfAmountExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleUnitOfAmountExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.VARIANCE)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.VOLATILITY)), (CardinalityOperator)CardinalityOperator.All)).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.CORRELATION)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)priceSchedule).map("getUnit", _priceSchedule -> _priceSchedule.getUnit())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)priceSchedule).map("getPerUnitOf", _priceSchedule -> _priceSchedule.getPerUnitOf())));
                }
                return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)priceSchedule).map("getUnit", _priceSchedule -> _priceSchedule.getUnit())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)priceSchedule).map("getPerUnitOf", _priceSchedule -> _priceSchedule.getPerUnitOf())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

