/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.ValuationMethod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ValuationMethodDealer")
@ImplementedBy(value=Default.class)
public interface ValuationMethodDealer
extends Validator<ValuationMethod> {
    public static final String NAME = "ValuationMethodDealer";
    public static final String DEFINITION = "if quotationAmount exists or minimumQuotationAmount exists then valuationSource -> dealerOrCCP -> legalEntity exists";

    public static class NoOp
    implements ValuationMethodDealer {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationMethod valuationMethod) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ValuationMethodDealer {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationMethod valuationMethod) {
            ComparisonResult result = this.executeDataRule(valuationMethod);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ValuationMethodDealer.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationMethod", (RosettaPath)path, (String)ValuationMethodDealer.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ValuationMethodDealer.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationMethod", (RosettaPath)path, (String)ValuationMethodDealer.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ValuationMethod valuationMethod) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)valuationMethod).map("getQuotationAmount", _valuationMethod -> _valuationMethod.getQuotationAmount())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)valuationMethod).map("getMinimumQuotationAmount", _valuationMethod -> _valuationMethod.getMinimumQuotationAmount()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)valuationMethod).map("getValuationSource", _valuationMethod -> _valuationMethod.getValuationSource()).map("getDealerOrCCP", valuationSource -> valuationSource.getDealerOrCCP()).map("getLegalEntity", ancillaryEntity -> ancillaryEntity.getLegalEntity()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

