/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.CreditDefaultPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CreditDefaultPayoutFpML_cd_12")
@ImplementedBy(value=Default.class)
public interface CreditDefaultPayoutFpML_cd_12
extends Validator<CreditDefaultPayout> {
    public static final String NAME = "CreditDefaultPayoutFpML_cd_12";
    public static final String DEFINITION = "if generalTerms -> referenceInformation -> referencePrice exists then generalTerms -> referenceInformation -> referencePrice -> value >= 0";

    public static class NoOp
    implements CreditDefaultPayoutFpML_cd_12 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditDefaultPayout creditDefaultPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CreditDefaultPayoutFpML_cd_12 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditDefaultPayout creditDefaultPayout) {
            ComparisonResult result = this.executeDataRule(creditDefaultPayout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CreditDefaultPayoutFpML_cd_12.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditDefaultPayout", (RosettaPath)path, (String)CreditDefaultPayoutFpML_cd_12.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CreditDefaultPayoutFpML_cd_12.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditDefaultPayout", (RosettaPath)path, (String)CreditDefaultPayoutFpML_cd_12.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CreditDefaultPayout creditDefaultPayout) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)creditDefaultPayout).map("getGeneralTerms", _creditDefaultPayout -> _creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferencePrice", referenceInformation -> referenceInformation.getReferencePrice())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)creditDefaultPayout).map("getGeneralTerms", _creditDefaultPayout -> _creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferencePrice", referenceInformation -> referenceInformation.getReferencePrice()).map("getValue", price -> price.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

