/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InterestRatePayoutFpML_ird_6")
@ImplementedBy(value=Default.class)
public interface InterestRatePayoutFpML_ird_6
extends Validator<InterestRatePayout> {
    public static final String NAME = "InterestRatePayoutFpML_ird_6";
    public static final String DEFINITION = "if paymentDates -> firstPaymentDate exists and calculationPeriodDates -> effectiveDate exists then paymentDates -> firstPaymentDate > calculationPeriodDates -> effectiveDate -> adjustableDate -> unadjustedDate";

    public static class NoOp
    implements InterestRatePayoutFpML_ird_6 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestRatePayout interestRatePayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InterestRatePayoutFpML_ird_6 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestRatePayout interestRatePayout) {
            ComparisonResult result = this.executeDataRule(interestRatePayout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InterestRatePayoutFpML_ird_6.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutFpML_ird_6.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InterestRatePayoutFpML_ird_6.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutFpML_ird_6.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(InterestRatePayout interestRatePayout) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getPaymentDates", _interestRatePayout -> _interestRatePayout.getPaymentDates()).map("getFirstPaymentDate", paymentDates -> paymentDates.getFirstPaymentDate())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)interestRatePayout).map("getPaymentDates", _interestRatePayout -> _interestRatePayout.getPaymentDates()).map("getFirstPaymentDate", paymentDates -> paymentDates.getFirstPaymentDate()), (Mapper)MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

