/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.RateSpecification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="RateSpecificationOneOf0")
@ImplementedBy(value=Default.class)
public interface RateSpecificationOneOf0
extends Validator<RateSpecification> {
    public static final String NAME = "RateSpecificationOneOf0";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements RateSpecificationOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RateSpecification rateSpecification) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements RateSpecificationOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RateSpecification rateSpecification) {
            ComparisonResult result = this.executeDataRule(rateSpecification);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)RateSpecificationOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RateSpecification", (RosettaPath)path, (String)RateSpecificationOneOf0.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)RateSpecificationOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RateSpecification", (RosettaPath)path, (String)RateSpecificationOneOf0.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(RateSpecification rateSpecification) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)rateSpecification), Arrays.asList("fixedRate", "floatingRate", "inflationRate"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

