/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.VolatilityCapFloor;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="VolatilityCapFloorCapFloorApplicability")
@ImplementedBy(value=Default.class)
public interface VolatilityCapFloorCapFloorApplicability
extends Validator<VolatilityCapFloor> {
    public static final String NAME = "VolatilityCapFloorCapFloorApplicability";
    public static final String DEFINITION = "if applicable = True then totalVolatilityCap exists or volatilityCapFactor exists else totalVolatilityCap is absent and volatilityCapFactor is absent";

    public static class NoOp
    implements VolatilityCapFloorCapFloorApplicability {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityCapFloor volatilityCapFloor) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements VolatilityCapFloorCapFloorApplicability {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityCapFloor volatilityCapFloor) {
            ComparisonResult result = this.executeDataRule(volatilityCapFloor);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)VolatilityCapFloorCapFloorApplicability.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityCapFloor", (RosettaPath)path, (String)VolatilityCapFloorCapFloorApplicability.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)VolatilityCapFloorCapFloorApplicability.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityCapFloor", (RosettaPath)path, (String)VolatilityCapFloorCapFloorApplicability.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(VolatilityCapFloor volatilityCapFloor) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)volatilityCapFloor).map("getApplicable", _volatilityCapFloor -> _volatilityCapFloor.getApplicable()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)volatilityCapFloor).map("getTotalVolatilityCap", _volatilityCapFloor -> _volatilityCapFloor.getTotalVolatilityCap())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)volatilityCapFloor).map("getVolatilityCapFactor", _volatilityCapFloor -> _volatilityCapFloor.getVolatilityCapFactor())));
                }
                return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)volatilityCapFloor).map("getTotalVolatilityCap", _volatilityCapFloor -> _volatilityCapFloor.getTotalVolatilityCap())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)volatilityCapFloor).map("getVolatilityCapFactor", _volatilityCapFloor -> _volatilityCapFloor.getVolatilityCapFactor())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

