/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.functions;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=InterestRatePayoutCurrencyDefault.class)
public abstract class InterestRatePayoutCurrency
implements RosettaFunction {
    public List<String> evaluate(List<? extends InterestRatePayout> interestRatePayouts) {
        List<String> currency = this.doEvaluate(interestRatePayouts);
        return currency;
    }

    protected abstract List<String> doEvaluate(List<? extends InterestRatePayout> var1);

    public static class InterestRatePayoutCurrencyDefault
    extends InterestRatePayoutCurrency {
        @Override
        protected List<String> doEvaluate(List<? extends InterestRatePayout> interestRatePayouts) {
            if (interestRatePayouts == null) {
                interestRatePayouts = Collections.emptyList();
            }
            ArrayList<String> currency = new ArrayList<String>();
            return this.assignOutput(currency, interestRatePayouts);
        }

        protected List<String> assignOutput(List<String> currency, List<? extends InterestRatePayout> interestRatePayouts) {
            currency.addAll(MapperC.of(interestRatePayouts).map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            currency.addAll(MapperC.of(interestRatePayouts).map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).map("getQuantityMultiplier", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantityMultiplier()).map("getFxLinkedNotionalSchedule", quantityMultiplier -> quantityMultiplier.getFxLinkedNotionalSchedule()).map("getVaryingNotionalCurrency", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getVaryingNotionalCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            return currency;
        }
    }
}

