/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.observable.asset.Money;
import cdm.product.common.schedule.CalculationPeriod;
import cdm.product.common.schedule.meta.PaymentCalculationPeriodMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PaymentCalculationPeriod", builder=PaymentCalculationPeriodBuilderImpl.class, version="5.31.0")
@RuneDataType(value="PaymentCalculationPeriod", model="cdm", builder=PaymentCalculationPeriodBuilderImpl.class, version="5.31.0")
public interface PaymentCalculationPeriod
extends RosettaModelObject,
GlobalKey {
    public static final PaymentCalculationPeriodMeta metaData = new PaymentCalculationPeriodMeta();

    public Date getUnadjustedPaymentDate();

    public Date getAdjustedPaymentDate();

    public List<? extends CalculationPeriod> getCalculationPeriod();

    public Money getFixedPaymentAmount();

    public BigDecimal getDiscountFactor();

    public Money getForecastPaymentAmount();

    public Money getPresentValueAmount();

    public MetaFields getMeta();

    public PaymentCalculationPeriod build();

    public PaymentCalculationPeriodBuilder toBuilder();

    public static PaymentCalculationPeriodBuilder builder() {
        return new PaymentCalculationPeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentCalculationPeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentCalculationPeriod> getType() {
        return PaymentCalculationPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("unadjustedPaymentDate"), Date.class, (Object)this.getUnadjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedPaymentDate"), Date.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriod.class, this.getCalculationPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPaymentAmount"), processor, Money.class, this.getFixedPaymentAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forecastPaymentAmount"), processor, Money.class, this.getForecastPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.class, this.getPresentValueAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PaymentCalculationPeriodBuilderImpl
    implements PaymentCalculationPeriodBuilder {
        protected Date unadjustedPaymentDate;
        protected Date adjustedPaymentDate;
        protected List<CalculationPeriod.CalculationPeriodBuilder> calculationPeriod = new ArrayList<CalculationPeriod.CalculationPeriodBuilder>();
        protected Money.MoneyBuilder fixedPaymentAmount;
        protected BigDecimal discountFactor;
        protected Money.MoneyBuilder forecastPaymentAmount;
        protected Money.MoneyBuilder presentValueAmount;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="unadjustedPaymentDate")
        @RuneAttribute(value="unadjustedPaymentDate")
        public Date getUnadjustedPaymentDate() {
            return this.unadjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public Date getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="calculationPeriod", isRequired=true)
        @RuneAttribute(value="calculationPeriod", isRequired=true)
        public List<? extends CalculationPeriod.CalculationPeriodBuilder> getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public CalculationPeriod.CalculationPeriodBuilder getOrCreateCalculationPeriod(int index) {
            if (this.calculationPeriod == null) {
                this.calculationPeriod = new ArrayList<CalculationPeriod.CalculationPeriodBuilder>();
            }
            return (CalculationPeriod.CalculationPeriodBuilder)this.getIndex(this.calculationPeriod, index, () -> {
                CalculationPeriod.CalculationPeriodBuilder newCalculationPeriod = CalculationPeriod.builder();
                return newCalculationPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="fixedPaymentAmount")
        @RuneAttribute(value="fixedPaymentAmount")
        public Money.MoneyBuilder getFixedPaymentAmount() {
            return this.fixedPaymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateFixedPaymentAmount() {
            Money.MoneyBuilder result = this.fixedPaymentAmount != null ? this.fixedPaymentAmount : (this.fixedPaymentAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="forecastPaymentAmount")
        @RuneAttribute(value="forecastPaymentAmount")
        public Money.MoneyBuilder getForecastPaymentAmount() {
            return this.forecastPaymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateForecastPaymentAmount() {
            Money.MoneyBuilder result = this.forecastPaymentAmount != null ? this.forecastPaymentAmount : (this.forecastPaymentAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money.MoneyBuilder getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValueAmount() {
            Money.MoneyBuilder result = this.presentValueAmount != null ? this.presentValueAmount : (this.presentValueAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="unadjustedPaymentDate")
        @RuneAttribute(value="unadjustedPaymentDate")
        public PaymentCalculationPeriodBuilder setUnadjustedPaymentDate(Date _unadjustedPaymentDate) {
            this.unadjustedPaymentDate = _unadjustedPaymentDate == null ? null : _unadjustedPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public PaymentCalculationPeriodBuilder setAdjustedPaymentDate(Date _adjustedPaymentDate) {
            this.adjustedPaymentDate = _adjustedPaymentDate == null ? null : _adjustedPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationPeriod", isRequired=true)
        @RuneAttribute(value="calculationPeriod", isRequired=true)
        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod _calculationPeriod) {
            if (_calculationPeriod != null) {
                this.calculationPeriod.add(_calculationPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod _calculationPeriod, int idx) {
            this.getIndex(this.calculationPeriod, idx, () -> _calculationPeriod.toBuilder());
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder addCalculationPeriod(List<? extends CalculationPeriod> calculationPeriods) {
            if (calculationPeriods != null) {
                for (CalculationPeriod calculationPeriod : calculationPeriods) {
                    this.calculationPeriod.add(calculationPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="calculationPeriod")
        public PaymentCalculationPeriodBuilder setCalculationPeriod(List<? extends CalculationPeriod> calculationPeriods) {
            this.calculationPeriod = calculationPeriods == null ? new ArrayList<CalculationPeriod.CalculationPeriodBuilder>() : (List)calculationPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPaymentAmount")
        @RuneAttribute(value="fixedPaymentAmount")
        public PaymentCalculationPeriodBuilder setFixedPaymentAmount(Money _fixedPaymentAmount) {
            this.fixedPaymentAmount = _fixedPaymentAmount == null ? null : _fixedPaymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public PaymentCalculationPeriodBuilder setDiscountFactor(BigDecimal _discountFactor) {
            this.discountFactor = _discountFactor == null ? null : _discountFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="forecastPaymentAmount")
        @RuneAttribute(value="forecastPaymentAmount")
        public PaymentCalculationPeriodBuilder setForecastPaymentAmount(Money _forecastPaymentAmount) {
            this.forecastPaymentAmount = _forecastPaymentAmount == null ? null : _forecastPaymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public PaymentCalculationPeriodBuilder setPresentValueAmount(Money _presentValueAmount) {
            this.presentValueAmount = _presentValueAmount == null ? null : _presentValueAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PaymentCalculationPeriodBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public PaymentCalculationPeriod build() {
            return new PaymentCalculationPeriodImpl(this);
        }

        @Override
        public PaymentCalculationPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder prune() {
            this.calculationPeriod = this.calculationPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fixedPaymentAmount != null && !this.fixedPaymentAmount.prune().hasData()) {
                this.fixedPaymentAmount = null;
            }
            if (this.forecastPaymentAmount != null && !this.forecastPaymentAmount.prune().hasData()) {
                this.forecastPaymentAmount = null;
            }
            if (this.presentValueAmount != null && !this.presentValueAmount.prune().hasData()) {
                this.presentValueAmount = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUnadjustedPaymentDate() != null) {
                return true;
            }
            if (this.getAdjustedPaymentDate() != null) {
                return true;
            }
            if (this.getCalculationPeriod() != null && this.getCalculationPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFixedPaymentAmount() != null && this.getFixedPaymentAmount().hasData()) {
                return true;
            }
            if (this.getDiscountFactor() != null) {
                return true;
            }
            if (this.getForecastPaymentAmount() != null && this.getForecastPaymentAmount().hasData()) {
                return true;
            }
            return this.getPresentValueAmount() != null && this.getPresentValueAmount().hasData();
        }

        public PaymentCalculationPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentCalculationPeriodBuilder o = (PaymentCalculationPeriodBuilder)other;
            merger.mergeRosetta(this.getCalculationPeriod(), o.getCalculationPeriod(), this::getOrCreateCalculationPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPaymentAmount(), (RosettaModelObjectBuilder)o.getFixedPaymentAmount(), this::setFixedPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForecastPaymentAmount(), (RosettaModelObjectBuilder)o.getForecastPaymentAmount(), this::setForecastPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValueAmount(), (RosettaModelObjectBuilder)o.getPresentValueAmount(), this::setPresentValueAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getUnadjustedPaymentDate(), (Object)o.getUnadjustedPaymentDate(), this::setUnadjustedPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedPaymentDate(), (Object)o.getAdjustedPaymentDate(), this::setAdjustedPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentCalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.unadjustedPaymentDate, _that.getUnadjustedPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixedPaymentAmount, _that.getFixedPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.forecastPaymentAmount, _that.getForecastPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedPaymentDate != null ? this.unadjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fixedPaymentAmount != null ? this.fixedPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.forecastPaymentAmount != null ? this.forecastPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentCalculationPeriodBuilder {unadjustedPaymentDate=" + this.unadjustedPaymentDate + ", adjustedPaymentDate=" + this.adjustedPaymentDate + ", calculationPeriod=" + this.calculationPeriod + ", fixedPaymentAmount=" + this.fixedPaymentAmount + ", discountFactor=" + this.discountFactor + ", forecastPaymentAmount=" + this.forecastPaymentAmount + ", presentValueAmount=" + this.presentValueAmount + ", meta=" + this.meta + '}';
        }
    }

    public static interface PaymentCalculationPeriodBuilder
    extends PaymentCalculationPeriod,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public CalculationPeriod.CalculationPeriodBuilder getOrCreateCalculationPeriod(int var1);

        public List<? extends CalculationPeriod.CalculationPeriodBuilder> getCalculationPeriod();

        public Money.MoneyBuilder getOrCreateFixedPaymentAmount();

        @Override
        public Money.MoneyBuilder getFixedPaymentAmount();

        public Money.MoneyBuilder getOrCreateForecastPaymentAmount();

        @Override
        public Money.MoneyBuilder getForecastPaymentAmount();

        public Money.MoneyBuilder getOrCreatePresentValueAmount();

        @Override
        public Money.MoneyBuilder getPresentValueAmount();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PaymentCalculationPeriodBuilder setUnadjustedPaymentDate(Date var1);

        public PaymentCalculationPeriodBuilder setAdjustedPaymentDate(Date var1);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod var1);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod var1, int var2);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(List<? extends CalculationPeriod> var1);

        public PaymentCalculationPeriodBuilder setCalculationPeriod(List<? extends CalculationPeriod> var1);

        public PaymentCalculationPeriodBuilder setFixedPaymentAmount(Money var1);

        public PaymentCalculationPeriodBuilder setDiscountFactor(BigDecimal var1);

        public PaymentCalculationPeriodBuilder setForecastPaymentAmount(Money var1);

        public PaymentCalculationPeriodBuilder setPresentValueAmount(Money var1);

        public PaymentCalculationPeriodBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("unadjustedPaymentDate"), Date.class, (Object)this.getUnadjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedPaymentDate"), Date.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriod.CalculationPeriodBuilder.class, this.getCalculationPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPaymentAmount"), processor, Money.MoneyBuilder.class, this.getFixedPaymentAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forecastPaymentAmount"), processor, Money.MoneyBuilder.class, this.getForecastPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.MoneyBuilder.class, this.getPresentValueAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PaymentCalculationPeriodBuilder prune();
    }

    public static class PaymentCalculationPeriodImpl
    implements PaymentCalculationPeriod {
        private final Date unadjustedPaymentDate;
        private final Date adjustedPaymentDate;
        private final List<? extends CalculationPeriod> calculationPeriod;
        private final Money fixedPaymentAmount;
        private final BigDecimal discountFactor;
        private final Money forecastPaymentAmount;
        private final Money presentValueAmount;
        private final MetaFields meta;

        protected PaymentCalculationPeriodImpl(PaymentCalculationPeriodBuilder builder) {
            this.unadjustedPaymentDate = builder.getUnadjustedPaymentDate();
            this.adjustedPaymentDate = builder.getAdjustedPaymentDate();
            this.calculationPeriod = Optional.ofNullable(builder.getCalculationPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fixedPaymentAmount = Optional.ofNullable(builder.getFixedPaymentAmount()).map(f -> f.build()).orElse(null);
            this.discountFactor = builder.getDiscountFactor();
            this.forecastPaymentAmount = Optional.ofNullable(builder.getForecastPaymentAmount()).map(f -> f.build()).orElse(null);
            this.presentValueAmount = Optional.ofNullable(builder.getPresentValueAmount()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="unadjustedPaymentDate")
        @RuneAttribute(value="unadjustedPaymentDate")
        public Date getUnadjustedPaymentDate() {
            return this.unadjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public Date getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="calculationPeriod", isRequired=true)
        @RuneAttribute(value="calculationPeriod", isRequired=true)
        public List<? extends CalculationPeriod> getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        @RosettaAttribute(value="fixedPaymentAmount")
        @RuneAttribute(value="fixedPaymentAmount")
        public Money getFixedPaymentAmount() {
            return this.fixedPaymentAmount;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="forecastPaymentAmount")
        @RuneAttribute(value="forecastPaymentAmount")
        public Money getForecastPaymentAmount() {
            return this.forecastPaymentAmount;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PaymentCalculationPeriod build() {
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder toBuilder() {
            PaymentCalculationPeriodBuilder builder = PaymentCalculationPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentCalculationPeriodBuilder builder) {
            Optional.ofNullable(this.getUnadjustedPaymentDate()).ifPresent(builder::setUnadjustedPaymentDate);
            Optional.ofNullable(this.getAdjustedPaymentDate()).ifPresent(builder::setAdjustedPaymentDate);
            Optional.ofNullable(this.getCalculationPeriod()).ifPresent(builder::setCalculationPeriod);
            Optional.ofNullable(this.getFixedPaymentAmount()).ifPresent(builder::setFixedPaymentAmount);
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getForecastPaymentAmount()).ifPresent(builder::setForecastPaymentAmount);
            Optional.ofNullable(this.getPresentValueAmount()).ifPresent(builder::setPresentValueAmount);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentCalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.unadjustedPaymentDate, _that.getUnadjustedPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixedPaymentAmount, _that.getFixedPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.forecastPaymentAmount, _that.getForecastPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedPaymentDate != null ? this.unadjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fixedPaymentAmount != null ? this.fixedPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.forecastPaymentAmount != null ? this.forecastPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentCalculationPeriod {unadjustedPaymentDate=" + this.unadjustedPaymentDate + ", adjustedPaymentDate=" + this.adjustedPaymentDate + ", calculationPeriod=" + this.calculationPeriod + ", fixedPaymentAmount=" + this.fixedPaymentAmount + ", discountFactor=" + this.discountFactor + ", forecastPaymentAmount=" + this.forecastPaymentAmount + ", presentValueAmount=" + this.presentValueAmount + ", meta=" + this.meta + '}';
        }
    }
}

