/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.functions;

import cdm.base.math.UnitType;
import cdm.base.math.functions.UnitEquals;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

@ImplementedBy(value=PriceUnitEqualsDefault.class)
public abstract class PriceUnitEquals
implements RosettaFunction {
    @Inject
    protected UnitEquals unitEquals;

    public Boolean evaluate(PriceSchedule p1, PriceSchedule p2) {
        Boolean result = this.doEvaluate(p1, p2);
        return result;
    }

    protected abstract Boolean doEvaluate(PriceSchedule var1, PriceSchedule var2);

    protected abstract MapperS<Boolean> unitMatches(PriceSchedule var1, PriceSchedule var2);

    protected abstract MapperS<Boolean> perUnitOfMatches(PriceSchedule var1, PriceSchedule var2);

    protected abstract MapperS<Boolean> priceTypeMatches(PriceSchedule var1, PriceSchedule var2);

    protected abstract MapperS<Boolean> priceExpressionMatches(PriceSchedule var1, PriceSchedule var2);

    protected abstract MapperS<Boolean> arithmeticOperatorMatches(PriceSchedule var1, PriceSchedule var2);

    public static class PriceUnitEqualsDefault
    extends PriceUnitEquals {
        @Override
        protected Boolean doEvaluate(PriceSchedule p1, PriceSchedule p2) {
            Boolean result = null;
            return this.assignOutput(result, p1, p2);
        }

        protected Boolean assignOutput(Boolean result, PriceSchedule p1, PriceSchedule p2) {
            result = ComparisonResult.ofNullSafe(this.unitMatches(p1, p2)).andNullSafe(ComparisonResult.ofNullSafe(this.perUnitOfMatches(p1, p2))).andNullSafe(ComparisonResult.ofNullSafe(this.priceTypeMatches(p1, p2))).andNullSafe(ComparisonResult.ofNullSafe(this.priceExpressionMatches(p1, p2))).andNullSafe(ComparisonResult.ofNullSafe(this.arithmeticOperatorMatches(p1, p2))).get();
            return result;
        }

        @Override
        protected MapperS<Boolean> unitMatches(PriceSchedule p1, PriceSchedule p2) {
            return MapperS.of((Object)this.unitEquals.evaluate((UnitType)MapperS.of((Object)p1).map("getUnit", priceSchedule -> priceSchedule.getUnit()).get(), (UnitType)MapperS.of((Object)p2).map("getUnit", priceSchedule -> priceSchedule.getUnit()).get()));
        }

        @Override
        protected MapperS<Boolean> perUnitOfMatches(PriceSchedule p1, PriceSchedule p2) {
            return MapperS.of((Object)this.unitEquals.evaluate((UnitType)MapperS.of((Object)p1).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get(), (UnitType)MapperS.of((Object)p2).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get()));
        }

        @Override
        protected MapperS<Boolean> priceTypeMatches(PriceSchedule p1, PriceSchedule p2) {
            return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)p1).map("getPriceType", priceSchedule -> priceSchedule.getPriceType())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)p2).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()))).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)p1).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)p2).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (CardinalityOperator)CardinalityOperator.All)).asMapper();
        }

        @Override
        protected MapperS<Boolean> priceExpressionMatches(PriceSchedule p1, PriceSchedule p2) {
            return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)p1).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)p2).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()))).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)p1).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (Mapper)MapperS.of((Object)p2).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (CardinalityOperator)CardinalityOperator.All)).asMapper();
        }

        @Override
        protected MapperS<Boolean> arithmeticOperatorMatches(PriceSchedule p1, PriceSchedule p2) {
            return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)p1).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)p2).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)p1).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()), (Mapper)MapperS.of((Object)p2).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()), (CardinalityOperator)CardinalityOperator.All)).asMapper();
        }
    }
}

