/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceQuantityActualSettlement")
@ImplementedBy(value=Default.class)
public interface PriceQuantityActualSettlement
extends Validator<PriceQuantity> {
    public static final String NAME = "PriceQuantityActualSettlement";
    public static final String DEFINITION = "if buyerSeller exists then settlementTerms exists";

    public static class NoOp
    implements PriceQuantityActualSettlement {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceQuantityActualSettlement {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            ComparisonResult result = this.executeDataRule(priceQuantity);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceQuantityActualSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityActualSettlement.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceQuantityActualSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityActualSettlement.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)priceQuantity).map("getBuyerSeller", _priceQuantity -> _priceQuantity.getBuyerSeller())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)priceQuantity).map("getSettlementTerms", _priceQuantity -> _priceQuantity.getSettlementTerms()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

