/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.ValuationDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ValuationDateOneOf0")
@ImplementedBy(value=Default.class)
public interface ValuationDateOneOf0
extends Validator<ValuationDate> {
    public static final String NAME = "ValuationDateOneOf0";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ValuationDateOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationDate valuationDate) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ValuationDateOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationDate valuationDate) {
            ComparisonResult result = this.executeDataRule(valuationDate);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ValuationDateOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationDate", (RosettaPath)path, (String)ValuationDateOneOf0.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ValuationDateOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationDate", (RosettaPath)path, (String)ValuationDateOneOf0.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ValuationDate valuationDate) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)valuationDate), Arrays.asList("singleValuationDate", "multipleValuationDates", "valuationDate", "fxFixingDate", "fxFixingSchedule"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

