/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.ExerciseFee;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.PartialExercise;
import cdm.product.template.meta.EuropeanExerciseMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EuropeanExercise", builder=EuropeanExerciseBuilderImpl.class, version="5.31.0")
@RuneDataType(value="EuropeanExercise", model="cdm", builder=EuropeanExerciseBuilderImpl.class, version="5.31.0")
public interface EuropeanExercise
extends RosettaModelObject,
GlobalKey {
    public static final EuropeanExerciseMeta metaData = new EuropeanExerciseMeta();

    public List<? extends AdjustableOrRelativeDate> getExpirationDate();

    public AdjustableOrRelativeDates getRelevantUnderlyingDate();

    public BusinessCenterTime getEarliestExerciseTime();

    public BusinessCenterTime getExpirationTime();

    public ExpirationTimeTypeEnum getExpirationTimeType();

    public PartialExercise getPartialExercise();

    public ExerciseFee getExerciseFee();

    public MetaFields getMeta();

    public EuropeanExercise build();

    public EuropeanExerciseBuilder toBuilder();

    public static EuropeanExerciseBuilder builder() {
        return new EuropeanExerciseBuilderImpl();
    }

    default public RosettaMetaData<? extends EuropeanExercise> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EuropeanExercise> getType() {
        return EuropeanExercise.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.class, this.getExpirationTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationTimeType"), ExpirationTimeTypeEnum.class, (Object)this.getExpirationTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.class, this.getPartialExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.class, this.getExerciseFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class EuropeanExerciseBuilderImpl
    implements EuropeanExerciseBuilder {
        protected List<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
        protected AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder relevantUnderlyingDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder earliestExerciseTime;
        protected BusinessCenterTime.BusinessCenterTimeBuilder expirationTime;
        protected ExpirationTimeTypeEnum expirationTimeType;
        protected PartialExercise.PartialExerciseBuilder partialExercise;
        protected ExerciseFee.ExerciseFeeBuilder exerciseFee;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int index) {
            if (this.expirationDate == null) {
                this.expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
            }
            return (AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder)this.getIndex(this.expirationDate, index, () -> {
                AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder newExpirationDate = AdjustableOrRelativeDate.builder();
                return newExpirationDate;
            });
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate() {
            AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder result = this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate : (this.relevantUnderlyingDate = AdjustableOrRelativeDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.earliestExerciseTime != null ? this.earliestExerciseTime : (this.earliestExerciseTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.expirationTime != null ? this.expirationTime : (this.expirationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationTimeType")
        @RuneAttribute(value="expirationTimeType")
        public ExpirationTimeTypeEnum getExpirationTimeType() {
            return this.expirationTimeType;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public PartialExercise.PartialExerciseBuilder getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise() {
            PartialExercise.PartialExerciseBuilder result = this.partialExercise != null ? this.partialExercise : (this.partialExercise = PartialExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee() {
            ExerciseFee.ExerciseFeeBuilder result = this.exerciseFee != null ? this.exerciseFee : (this.exerciseFee = ExerciseFee.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            if (_expirationDate != null) {
                this.expirationDate.add(_expirationDate.toBuilder());
            }
            return this;
        }

        @Override
        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate _expirationDate, int idx) {
            this.getIndex(this.expirationDate, idx, () -> _expirationDate.toBuilder());
            return this;
        }

        @Override
        public EuropeanExerciseBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            if (expirationDates != null) {
                for (AdjustableOrRelativeDate adjustableOrRelativeDate : expirationDates) {
                    this.expirationDate.add(adjustableOrRelativeDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="expirationDate")
        public EuropeanExerciseBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            this.expirationDate = expirationDates == null ? new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>() : (List)expirationDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public EuropeanExerciseBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates _relevantUnderlyingDate) {
            this.relevantUnderlyingDate = _relevantUnderlyingDate == null ? null : _relevantUnderlyingDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public EuropeanExerciseBuilder setEarliestExerciseTime(BusinessCenterTime _earliestExerciseTime) {
            this.earliestExerciseTime = _earliestExerciseTime == null ? null : _earliestExerciseTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public EuropeanExerciseBuilder setExpirationTime(BusinessCenterTime _expirationTime) {
            this.expirationTime = _expirationTime == null ? null : _expirationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationTimeType")
        @RuneAttribute(value="expirationTimeType")
        public EuropeanExerciseBuilder setExpirationTimeType(ExpirationTimeTypeEnum _expirationTimeType) {
            this.expirationTimeType = _expirationTimeType == null ? null : _expirationTimeType;
            return this;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public EuropeanExerciseBuilder setPartialExercise(PartialExercise _partialExercise) {
            this.partialExercise = _partialExercise == null ? null : _partialExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public EuropeanExerciseBuilder setExerciseFee(ExerciseFee _exerciseFee) {
            this.exerciseFee = _exerciseFee == null ? null : _exerciseFee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public EuropeanExerciseBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public EuropeanExercise build() {
            return new EuropeanExerciseImpl(this);
        }

        @Override
        public EuropeanExerciseBuilder toBuilder() {
            return this;
        }

        @Override
        public EuropeanExerciseBuilder prune() {
            this.expirationDate = this.expirationDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.relevantUnderlyingDate != null && !this.relevantUnderlyingDate.prune().hasData()) {
                this.relevantUnderlyingDate = null;
            }
            if (this.earliestExerciseTime != null && !this.earliestExerciseTime.prune().hasData()) {
                this.earliestExerciseTime = null;
            }
            if (this.expirationTime != null && !this.expirationTime.prune().hasData()) {
                this.expirationTime = null;
            }
            if (this.partialExercise != null && !this.partialExercise.prune().hasData()) {
                this.partialExercise = null;
            }
            if (this.exerciseFee != null && !this.exerciseFee.prune().hasData()) {
                this.exerciseFee = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getExpirationDate() != null && this.getExpirationDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRelevantUnderlyingDate() != null && this.getRelevantUnderlyingDate().hasData()) {
                return true;
            }
            if (this.getEarliestExerciseTime() != null && this.getEarliestExerciseTime().hasData()) {
                return true;
            }
            if (this.getExpirationTime() != null && this.getExpirationTime().hasData()) {
                return true;
            }
            if (this.getExpirationTimeType() != null) {
                return true;
            }
            if (this.getPartialExercise() != null && this.getPartialExercise().hasData()) {
                return true;
            }
            return this.getExerciseFee() != null && this.getExerciseFee().hasData();
        }

        public EuropeanExerciseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EuropeanExerciseBuilder o = (EuropeanExerciseBuilder)other;
            merger.mergeRosetta(this.getExpirationDate(), o.getExpirationDate(), this::getOrCreateExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRelevantUnderlyingDate(), (RosettaModelObjectBuilder)o.getRelevantUnderlyingDate(), this::setRelevantUnderlyingDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestExerciseTime(), (RosettaModelObjectBuilder)o.getEarliestExerciseTime(), this::setEarliestExerciseTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationTime(), (RosettaModelObjectBuilder)o.getExpirationTime(), this::setExpirationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartialExercise(), (RosettaModelObjectBuilder)o.getPartialExercise(), this::setPartialExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFee(), (RosettaModelObjectBuilder)o.getExerciseFee(), this::setExerciseFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getExpirationTimeType(), (Object)o.getExpirationTimeType(), this::setExpirationTimeType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EuropeanExercise _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate())) {
                return false;
            }
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.expirationTimeType, (Object)_that.getExpirationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFee, _that.getExerciseFee())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTimeType != null ? ((Object)((Object)this.expirationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EuropeanExerciseBuilder {expirationDate=" + this.expirationDate + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + ", earliestExerciseTime=" + this.earliestExerciseTime + ", expirationTime=" + this.expirationTime + ", expirationTimeType=" + (Object)((Object)this.expirationTimeType) + ", partialExercise=" + this.partialExercise + ", exerciseFee=" + this.exerciseFee + ", meta=" + this.meta + '}';
        }
    }

    public static interface EuropeanExerciseBuilder
    extends EuropeanExercise,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int var1);

        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate();

        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate();

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime();

        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise();

        @Override
        public PartialExercise.PartialExerciseBuilder getPartialExercise();

        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee();

        @Override
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate var1);

        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate var1, int var2);

        public EuropeanExerciseBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public EuropeanExerciseBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public EuropeanExerciseBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates var1);

        public EuropeanExerciseBuilder setEarliestExerciseTime(BusinessCenterTime var1);

        public EuropeanExerciseBuilder setExpirationTime(BusinessCenterTime var1);

        public EuropeanExerciseBuilder setExpirationTimeType(ExpirationTimeTypeEnum var1);

        public EuropeanExerciseBuilder setPartialExercise(PartialExercise var1);

        public EuropeanExerciseBuilder setExerciseFee(ExerciseFee var1);

        public EuropeanExerciseBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getExpirationTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationTimeType"), ExpirationTimeTypeEnum.class, (Object)this.getExpirationTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.PartialExerciseBuilder.class, this.getPartialExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.ExerciseFeeBuilder.class, this.getExerciseFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public EuropeanExerciseBuilder prune();
    }

    public static class EuropeanExerciseImpl
    implements EuropeanExercise {
        private final List<? extends AdjustableOrRelativeDate> expirationDate;
        private final AdjustableOrRelativeDates relevantUnderlyingDate;
        private final BusinessCenterTime earliestExerciseTime;
        private final BusinessCenterTime expirationTime;
        private final ExpirationTimeTypeEnum expirationTimeType;
        private final PartialExercise partialExercise;
        private final ExerciseFee exerciseFee;
        private final MetaFields meta;

        protected EuropeanExerciseImpl(EuropeanExerciseBuilder builder) {
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.relevantUnderlyingDate = Optional.ofNullable(builder.getRelevantUnderlyingDate()).map(f -> f.build()).orElse(null);
            this.earliestExerciseTime = Optional.ofNullable(builder.getEarliestExerciseTime()).map(f -> f.build()).orElse(null);
            this.expirationTime = Optional.ofNullable(builder.getExpirationTime()).map(f -> f.build()).orElse(null);
            this.expirationTimeType = builder.getExpirationTimeType();
            this.partialExercise = Optional.ofNullable(builder.getPartialExercise()).map(f -> f.build()).orElse(null);
            this.exerciseFee = Optional.ofNullable(builder.getExerciseFee()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public List<? extends AdjustableOrRelativeDate> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public AdjustableOrRelativeDates getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public BusinessCenterTime getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public BusinessCenterTime getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        @RosettaAttribute(value="expirationTimeType")
        @RuneAttribute(value="expirationTimeType")
        public ExpirationTimeTypeEnum getExpirationTimeType() {
            return this.expirationTimeType;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public PartialExercise getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public ExerciseFee getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public EuropeanExercise build() {
            return this;
        }

        @Override
        public EuropeanExerciseBuilder toBuilder() {
            EuropeanExerciseBuilder builder = EuropeanExercise.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EuropeanExerciseBuilder builder) {
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getRelevantUnderlyingDate()).ifPresent(builder::setRelevantUnderlyingDate);
            Optional.ofNullable(this.getEarliestExerciseTime()).ifPresent(builder::setEarliestExerciseTime);
            Optional.ofNullable(this.getExpirationTime()).ifPresent(builder::setExpirationTime);
            Optional.ofNullable(this.getExpirationTimeType()).ifPresent(builder::setExpirationTimeType);
            Optional.ofNullable(this.getPartialExercise()).ifPresent(builder::setPartialExercise);
            Optional.ofNullable(this.getExerciseFee()).ifPresent(builder::setExerciseFee);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EuropeanExercise _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate())) {
                return false;
            }
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.expirationTimeType, (Object)_that.getExpirationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFee, _that.getExerciseFee())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTimeType != null ? ((Object)((Object)this.expirationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EuropeanExercise {expirationDate=" + this.expirationDate + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + ", earliestExerciseTime=" + this.earliestExerciseTime + ", expirationTime=" + this.expirationTime + ", expirationTimeType=" + (Object)((Object)this.expirationTimeType) + ", partialExercise=" + this.partialExercise + ", exerciseFee=" + this.exerciseFee + ", meta=" + this.meta + '}';
        }
    }
}

