/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableRelativeOrPeriodicDates;
import cdm.base.datetime.RelativeDateOffset;
import cdm.base.staticdata.party.BuyerSeller;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PartyRole;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.CallingPartyEnum;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.ExerciseNotice;
import cdm.product.template.ExtendibleProvisionAdjustedDates;
import cdm.product.template.meta.ExtendibleProvisionMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExtendibleProvision", builder=ExtendibleProvisionBuilderImpl.class, version="5.31.0")
@RuneDataType(value="ExtendibleProvision", model="cdm", builder=ExtendibleProvisionBuilderImpl.class, version="5.31.0")
public interface ExtendibleProvision
extends BuyerSeller {
    public static final ExtendibleProvisionMeta metaData = new ExtendibleProvisionMeta();

    public AmericanExercise getAmericanExercise();

    public BermudaExercise getBermudaExercise();

    public EuropeanExercise getEuropeanExercise();

    public ExerciseNotice getExerciseNotice();

    public Boolean getFollowUpConfirmation();

    public ExtendibleProvisionAdjustedDates getExtendibleProvisionAdjustedDates();

    public CallingPartyEnum getCallingParty();

    public PartyRole getSinglePartyOption();

    public RelativeDateOffset getNoticeDeadlinePeriod();

    public ZonedDateTime getNoticeDeadlineDateTime();

    public RelativeDateOffset getExtensionTerm();

    public AdjustableRelativeOrPeriodicDates getExtensionPeriod();

    @Override
    public ExtendibleProvision build();

    @Override
    public ExtendibleProvisionBuilder toBuilder();

    public static ExtendibleProvisionBuilder builder() {
        return new ExtendibleProvisionBuilderImpl();
    }

    default public RosettaMetaData<? extends ExtendibleProvision> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExtendibleProvision> getType() {
        return ExtendibleProvision.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("buyer"), CounterpartyRoleEnum.class, (Object)this.getBuyer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seller"), CounterpartyRoleEnum.class, (Object)this.getSeller(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("americanExercise"), processor, AmericanExercise.class, this.getAmericanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bermudaExercise"), processor, BermudaExercise.class, this.getBermudaExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("europeanExercise"), processor, EuropeanExercise.class, this.getEuropeanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseNotice"), processor, ExerciseNotice.class, this.getExerciseNotice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("followUpConfirmation"), Boolean.class, (Object)this.getFollowUpConfirmation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extendibleProvisionAdjustedDates"), processor, ExtendibleProvisionAdjustedDates.class, this.getExtendibleProvisionAdjustedDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("singlePartyOption"), processor, PartyRole.class, this.getSinglePartyOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("noticeDeadlinePeriod"), processor, RelativeDateOffset.class, this.getNoticeDeadlinePeriod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDeadlineDateTime"), ZonedDateTime.class, (Object)this.getNoticeDeadlineDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extensionTerm"), processor, RelativeDateOffset.class, this.getExtensionTerm(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extensionPeriod"), processor, AdjustableRelativeOrPeriodicDates.class, this.getExtensionPeriod(), new AttributeMeta[0]);
    }

    public static class ExtendibleProvisionBuilderImpl
    extends BuyerSeller.BuyerSellerBuilderImpl
    implements ExtendibleProvisionBuilder {
        protected AmericanExercise.AmericanExerciseBuilder americanExercise;
        protected BermudaExercise.BermudaExerciseBuilder bermudaExercise;
        protected EuropeanExercise.EuropeanExerciseBuilder europeanExercise;
        protected ExerciseNotice.ExerciseNoticeBuilder exerciseNotice;
        protected Boolean followUpConfirmation;
        protected ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDatesBuilder extendibleProvisionAdjustedDates;
        protected CallingPartyEnum callingParty;
        protected PartyRole.PartyRoleBuilder singlePartyOption;
        protected RelativeDateOffset.RelativeDateOffsetBuilder noticeDeadlinePeriod;
        protected ZonedDateTime noticeDeadlineDateTime;
        protected RelativeDateOffset.RelativeDateOffsetBuilder extensionTerm;
        protected AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder extensionPeriod;

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public AmericanExercise.AmericanExerciseBuilder getAmericanExercise() {
            return this.americanExercise;
        }

        @Override
        public AmericanExercise.AmericanExerciseBuilder getOrCreateAmericanExercise() {
            AmericanExercise.AmericanExerciseBuilder result = this.americanExercise != null ? this.americanExercise : (this.americanExercise = AmericanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bermudaExercise")
        @RuneAttribute(value="bermudaExercise")
        public BermudaExercise.BermudaExerciseBuilder getBermudaExercise() {
            return this.bermudaExercise;
        }

        @Override
        public BermudaExercise.BermudaExerciseBuilder getOrCreateBermudaExercise() {
            BermudaExercise.BermudaExerciseBuilder result = this.bermudaExercise != null ? this.bermudaExercise : (this.bermudaExercise = BermudaExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public EuropeanExercise.EuropeanExerciseBuilder getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        public EuropeanExercise.EuropeanExerciseBuilder getOrCreateEuropeanExercise() {
            EuropeanExercise.EuropeanExerciseBuilder result = this.europeanExercise != null ? this.europeanExercise : (this.europeanExercise = EuropeanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public ExerciseNotice.ExerciseNoticeBuilder getExerciseNotice() {
            return this.exerciseNotice;
        }

        @Override
        public ExerciseNotice.ExerciseNoticeBuilder getOrCreateExerciseNotice() {
            ExerciseNotice.ExerciseNoticeBuilder result = this.exerciseNotice != null ? this.exerciseNotice : (this.exerciseNotice = ExerciseNotice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation")
        @RuneAttribute(value="followUpConfirmation")
        public Boolean getFollowUpConfirmation() {
            return this.followUpConfirmation;
        }

        @Override
        @RosettaAttribute(value="extendibleProvisionAdjustedDates")
        @RuneAttribute(value="extendibleProvisionAdjustedDates")
        public ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDatesBuilder getExtendibleProvisionAdjustedDates() {
            return this.extendibleProvisionAdjustedDates;
        }

        @Override
        public ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDatesBuilder getOrCreateExtendibleProvisionAdjustedDates() {
            ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDatesBuilder result = this.extendibleProvisionAdjustedDates != null ? this.extendibleProvisionAdjustedDates : (this.extendibleProvisionAdjustedDates = ExtendibleProvisionAdjustedDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callingParty")
        @RuneAttribute(value="callingParty")
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="singlePartyOption")
        @RuneAttribute(value="singlePartyOption")
        public PartyRole.PartyRoleBuilder getSinglePartyOption() {
            return this.singlePartyOption;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreateSinglePartyOption() {
            PartyRole.PartyRoleBuilder result = this.singlePartyOption != null ? this.singlePartyOption : (this.singlePartyOption = PartyRole.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="noticeDeadlinePeriod")
        @RuneAttribute(value="noticeDeadlinePeriod")
        public RelativeDateOffset.RelativeDateOffsetBuilder getNoticeDeadlinePeriod() {
            return this.noticeDeadlinePeriod;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateNoticeDeadlinePeriod() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod : (this.noticeDeadlinePeriod = RelativeDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="noticeDeadlineDateTime")
        @RuneAttribute(value="noticeDeadlineDateTime")
        public ZonedDateTime getNoticeDeadlineDateTime() {
            return this.noticeDeadlineDateTime;
        }

        @Override
        @RosettaAttribute(value="extensionTerm")
        @RuneAttribute(value="extensionTerm")
        public RelativeDateOffset.RelativeDateOffsetBuilder getExtensionTerm() {
            return this.extensionTerm;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateExtensionTerm() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.extensionTerm != null ? this.extensionTerm : (this.extensionTerm = RelativeDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="extensionPeriod")
        @RuneAttribute(value="extensionPeriod")
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getExtensionPeriod() {
            return this.extensionPeriod;
        }

        @Override
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getOrCreateExtensionPeriod() {
            AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder result = this.extensionPeriod != null ? this.extensionPeriod : (this.extensionPeriod = AdjustableRelativeOrPeriodicDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="buyer", isRequired=true)
        @RuneAttribute(value="buyer", isRequired=true)
        public ExtendibleProvisionBuilder setBuyer(CounterpartyRoleEnum _buyer) {
            this.buyer = _buyer == null ? null : _buyer;
            return this;
        }

        @Override
        @RosettaAttribute(value="seller", isRequired=true)
        @RuneAttribute(value="seller", isRequired=true)
        public ExtendibleProvisionBuilder setSeller(CounterpartyRoleEnum _seller) {
            this.seller = _seller == null ? null : _seller;
            return this;
        }

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public ExtendibleProvisionBuilder setAmericanExercise(AmericanExercise _americanExercise) {
            this.americanExercise = _americanExercise == null ? null : _americanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bermudaExercise")
        @RuneAttribute(value="bermudaExercise")
        public ExtendibleProvisionBuilder setBermudaExercise(BermudaExercise _bermudaExercise) {
            this.bermudaExercise = _bermudaExercise == null ? null : _bermudaExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public ExtendibleProvisionBuilder setEuropeanExercise(EuropeanExercise _europeanExercise) {
            this.europeanExercise = _europeanExercise == null ? null : _europeanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public ExtendibleProvisionBuilder setExerciseNotice(ExerciseNotice _exerciseNotice) {
            this.exerciseNotice = _exerciseNotice == null ? null : _exerciseNotice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation")
        @RuneAttribute(value="followUpConfirmation")
        public ExtendibleProvisionBuilder setFollowUpConfirmation(Boolean _followUpConfirmation) {
            this.followUpConfirmation = _followUpConfirmation == null ? null : _followUpConfirmation;
            return this;
        }

        @Override
        @RosettaAttribute(value="extendibleProvisionAdjustedDates")
        @RuneAttribute(value="extendibleProvisionAdjustedDates")
        public ExtendibleProvisionBuilder setExtendibleProvisionAdjustedDates(ExtendibleProvisionAdjustedDates _extendibleProvisionAdjustedDates) {
            this.extendibleProvisionAdjustedDates = _extendibleProvisionAdjustedDates == null ? null : _extendibleProvisionAdjustedDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callingParty")
        @RuneAttribute(value="callingParty")
        public ExtendibleProvisionBuilder setCallingParty(CallingPartyEnum _callingParty) {
            this.callingParty = _callingParty == null ? null : _callingParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="singlePartyOption")
        @RuneAttribute(value="singlePartyOption")
        public ExtendibleProvisionBuilder setSinglePartyOption(PartyRole _singlePartyOption) {
            this.singlePartyOption = _singlePartyOption == null ? null : _singlePartyOption.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDeadlinePeriod")
        @RuneAttribute(value="noticeDeadlinePeriod")
        public ExtendibleProvisionBuilder setNoticeDeadlinePeriod(RelativeDateOffset _noticeDeadlinePeriod) {
            this.noticeDeadlinePeriod = _noticeDeadlinePeriod == null ? null : _noticeDeadlinePeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDeadlineDateTime")
        @RuneAttribute(value="noticeDeadlineDateTime")
        public ExtendibleProvisionBuilder setNoticeDeadlineDateTime(ZonedDateTime _noticeDeadlineDateTime) {
            this.noticeDeadlineDateTime = _noticeDeadlineDateTime == null ? null : _noticeDeadlineDateTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="extensionTerm")
        @RuneAttribute(value="extensionTerm")
        public ExtendibleProvisionBuilder setExtensionTerm(RelativeDateOffset _extensionTerm) {
            this.extensionTerm = _extensionTerm == null ? null : _extensionTerm.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="extensionPeriod")
        @RuneAttribute(value="extensionPeriod")
        public ExtendibleProvisionBuilder setExtensionPeriod(AdjustableRelativeOrPeriodicDates _extensionPeriod) {
            this.extensionPeriod = _extensionPeriod == null ? null : _extensionPeriod.toBuilder();
            return this;
        }

        @Override
        public ExtendibleProvision build() {
            return new ExtendibleProvisionImpl(this);
        }

        @Override
        public ExtendibleProvisionBuilder toBuilder() {
            return this;
        }

        @Override
        public ExtendibleProvisionBuilder prune() {
            super.prune();
            if (this.americanExercise != null && !this.americanExercise.prune().hasData()) {
                this.americanExercise = null;
            }
            if (this.bermudaExercise != null && !this.bermudaExercise.prune().hasData()) {
                this.bermudaExercise = null;
            }
            if (this.europeanExercise != null && !this.europeanExercise.prune().hasData()) {
                this.europeanExercise = null;
            }
            if (this.exerciseNotice != null && !this.exerciseNotice.prune().hasData()) {
                this.exerciseNotice = null;
            }
            if (this.extendibleProvisionAdjustedDates != null && !this.extendibleProvisionAdjustedDates.prune().hasData()) {
                this.extendibleProvisionAdjustedDates = null;
            }
            if (this.singlePartyOption != null && !this.singlePartyOption.prune().hasData()) {
                this.singlePartyOption = null;
            }
            if (this.noticeDeadlinePeriod != null && !this.noticeDeadlinePeriod.prune().hasData()) {
                this.noticeDeadlinePeriod = null;
            }
            if (this.extensionTerm != null && !this.extensionTerm.prune().hasData()) {
                this.extensionTerm = null;
            }
            if (this.extensionPeriod != null && !this.extensionPeriod.prune().hasData()) {
                this.extensionPeriod = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAmericanExercise() != null && this.getAmericanExercise().hasData()) {
                return true;
            }
            if (this.getBermudaExercise() != null && this.getBermudaExercise().hasData()) {
                return true;
            }
            if (this.getEuropeanExercise() != null && this.getEuropeanExercise().hasData()) {
                return true;
            }
            if (this.getExerciseNotice() != null && this.getExerciseNotice().hasData()) {
                return true;
            }
            if (this.getFollowUpConfirmation() != null) {
                return true;
            }
            if (this.getExtendibleProvisionAdjustedDates() != null && this.getExtendibleProvisionAdjustedDates().hasData()) {
                return true;
            }
            if (this.getCallingParty() != null) {
                return true;
            }
            if (this.getSinglePartyOption() != null && this.getSinglePartyOption().hasData()) {
                return true;
            }
            if (this.getNoticeDeadlinePeriod() != null && this.getNoticeDeadlinePeriod().hasData()) {
                return true;
            }
            if (this.getNoticeDeadlineDateTime() != null) {
                return true;
            }
            if (this.getExtensionTerm() != null && this.getExtensionTerm().hasData()) {
                return true;
            }
            return this.getExtensionPeriod() != null && this.getExtensionPeriod().hasData();
        }

        @Override
        public ExtendibleProvisionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExtendibleProvisionBuilder o = (ExtendibleProvisionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmericanExercise(), (RosettaModelObjectBuilder)o.getAmericanExercise(), this::setAmericanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBermudaExercise(), (RosettaModelObjectBuilder)o.getBermudaExercise(), this::setBermudaExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEuropeanExercise(), (RosettaModelObjectBuilder)o.getEuropeanExercise(), this::setEuropeanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseNotice(), (RosettaModelObjectBuilder)o.getExerciseNotice(), this::setExerciseNotice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtendibleProvisionAdjustedDates(), (RosettaModelObjectBuilder)o.getExtendibleProvisionAdjustedDates(), this::setExtendibleProvisionAdjustedDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSinglePartyOption(), (RosettaModelObjectBuilder)o.getSinglePartyOption(), this::setSinglePartyOption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNoticeDeadlinePeriod(), (RosettaModelObjectBuilder)o.getNoticeDeadlinePeriod(), this::setNoticeDeadlinePeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtensionTerm(), (RosettaModelObjectBuilder)o.getExtensionTerm(), this::setExtensionTerm);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtensionPeriod(), (RosettaModelObjectBuilder)o.getExtensionPeriod(), this::setExtensionPeriod);
            merger.mergeBasic((Object)this.getFollowUpConfirmation(), (Object)o.getFollowUpConfirmation(), this::setFollowUpConfirmation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallingParty(), (Object)o.getCallingParty(), this::setCallingParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNoticeDeadlineDateTime(), (Object)o.getNoticeDeadlineDateTime(), this::setNoticeDeadlineDateTime, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtendibleProvision _that = (ExtendibleProvision)this.getType().cast(o);
            if (!Objects.equals(this.americanExercise, _that.getAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.bermudaExercise, _that.getBermudaExercise())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseNotice, _that.getExerciseNotice())) {
                return false;
            }
            if (!Objects.equals(this.followUpConfirmation, _that.getFollowUpConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.extendibleProvisionAdjustedDates, _that.getExtendibleProvisionAdjustedDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.singlePartyOption, _that.getSinglePartyOption())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlinePeriod, _that.getNoticeDeadlinePeriod())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlineDateTime, _that.getNoticeDeadlineDateTime())) {
                return false;
            }
            if (!Objects.equals(this.extensionTerm, _that.getExtensionTerm())) {
                return false;
            }
            return Objects.equals(this.extensionPeriod, _that.getExtensionPeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.americanExercise != null ? this.americanExercise.hashCode() : 0);
            _result = 31 * _result + (this.bermudaExercise != null ? this.bermudaExercise.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseNotice != null ? this.exerciseNotice.hashCode() : 0);
            _result = 31 * _result + (this.followUpConfirmation != null ? this.followUpConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.extendibleProvisionAdjustedDates != null ? this.extendibleProvisionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.singlePartyOption != null ? this.singlePartyOption.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlineDateTime != null ? this.noticeDeadlineDateTime.hashCode() : 0);
            _result = 31 * _result + (this.extensionTerm != null ? this.extensionTerm.hashCode() : 0);
            _result = 31 * _result + (this.extensionPeriod != null ? this.extensionPeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExtendibleProvisionBuilder {americanExercise=" + this.americanExercise + ", bermudaExercise=" + this.bermudaExercise + ", europeanExercise=" + this.europeanExercise + ", exerciseNotice=" + this.exerciseNotice + ", followUpConfirmation=" + this.followUpConfirmation + ", extendibleProvisionAdjustedDates=" + this.extendibleProvisionAdjustedDates + ", callingParty=" + (Object)((Object)this.callingParty) + ", singlePartyOption=" + this.singlePartyOption + ", noticeDeadlinePeriod=" + this.noticeDeadlinePeriod + ", noticeDeadlineDateTime=" + this.noticeDeadlineDateTime + ", extensionTerm=" + this.extensionTerm + ", extensionPeriod=" + this.extensionPeriod + '}' + " " + super.toString();
        }
    }

    public static interface ExtendibleProvisionBuilder
    extends ExtendibleProvision,
    BuyerSeller.BuyerSellerBuilder {
        public AmericanExercise.AmericanExerciseBuilder getOrCreateAmericanExercise();

        @Override
        public AmericanExercise.AmericanExerciseBuilder getAmericanExercise();

        public BermudaExercise.BermudaExerciseBuilder getOrCreateBermudaExercise();

        @Override
        public BermudaExercise.BermudaExerciseBuilder getBermudaExercise();

        public EuropeanExercise.EuropeanExerciseBuilder getOrCreateEuropeanExercise();

        @Override
        public EuropeanExercise.EuropeanExerciseBuilder getEuropeanExercise();

        public ExerciseNotice.ExerciseNoticeBuilder getOrCreateExerciseNotice();

        @Override
        public ExerciseNotice.ExerciseNoticeBuilder getExerciseNotice();

        public ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDatesBuilder getOrCreateExtendibleProvisionAdjustedDates();

        @Override
        public ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDatesBuilder getExtendibleProvisionAdjustedDates();

        public PartyRole.PartyRoleBuilder getOrCreateSinglePartyOption();

        @Override
        public PartyRole.PartyRoleBuilder getSinglePartyOption();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateNoticeDeadlinePeriod();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getNoticeDeadlinePeriod();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateExtensionTerm();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getExtensionTerm();

        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getOrCreateExtensionPeriod();

        @Override
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getExtensionPeriod();

        @Override
        public ExtendibleProvisionBuilder setBuyer(CounterpartyRoleEnum var1);

        @Override
        public ExtendibleProvisionBuilder setSeller(CounterpartyRoleEnum var1);

        public ExtendibleProvisionBuilder setAmericanExercise(AmericanExercise var1);

        public ExtendibleProvisionBuilder setBermudaExercise(BermudaExercise var1);

        public ExtendibleProvisionBuilder setEuropeanExercise(EuropeanExercise var1);

        public ExtendibleProvisionBuilder setExerciseNotice(ExerciseNotice var1);

        public ExtendibleProvisionBuilder setFollowUpConfirmation(Boolean var1);

        public ExtendibleProvisionBuilder setExtendibleProvisionAdjustedDates(ExtendibleProvisionAdjustedDates var1);

        public ExtendibleProvisionBuilder setCallingParty(CallingPartyEnum var1);

        public ExtendibleProvisionBuilder setSinglePartyOption(PartyRole var1);

        public ExtendibleProvisionBuilder setNoticeDeadlinePeriod(RelativeDateOffset var1);

        public ExtendibleProvisionBuilder setNoticeDeadlineDateTime(ZonedDateTime var1);

        public ExtendibleProvisionBuilder setExtensionTerm(RelativeDateOffset var1);

        public ExtendibleProvisionBuilder setExtensionPeriod(AdjustableRelativeOrPeriodicDates var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("buyer"), CounterpartyRoleEnum.class, (Object)this.getBuyer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seller"), CounterpartyRoleEnum.class, (Object)this.getSeller(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("americanExercise"), processor, AmericanExercise.AmericanExerciseBuilder.class, this.getAmericanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bermudaExercise"), processor, BermudaExercise.BermudaExerciseBuilder.class, this.getBermudaExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("europeanExercise"), processor, EuropeanExercise.EuropeanExerciseBuilder.class, this.getEuropeanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseNotice"), processor, ExerciseNotice.ExerciseNoticeBuilder.class, this.getExerciseNotice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("followUpConfirmation"), Boolean.class, (Object)this.getFollowUpConfirmation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extendibleProvisionAdjustedDates"), processor, ExtendibleProvisionAdjustedDates.ExtendibleProvisionAdjustedDatesBuilder.class, this.getExtendibleProvisionAdjustedDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("singlePartyOption"), processor, PartyRole.PartyRoleBuilder.class, this.getSinglePartyOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("noticeDeadlinePeriod"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getNoticeDeadlinePeriod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDeadlineDateTime"), ZonedDateTime.class, (Object)this.getNoticeDeadlineDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extensionTerm"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getExtensionTerm(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extensionPeriod"), processor, AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder.class, this.getExtensionPeriod(), new AttributeMeta[0]);
        }

        @Override
        public ExtendibleProvisionBuilder prune();
    }

    public static class ExtendibleProvisionImpl
    extends BuyerSeller.BuyerSellerImpl
    implements ExtendibleProvision {
        private final AmericanExercise americanExercise;
        private final BermudaExercise bermudaExercise;
        private final EuropeanExercise europeanExercise;
        private final ExerciseNotice exerciseNotice;
        private final Boolean followUpConfirmation;
        private final ExtendibleProvisionAdjustedDates extendibleProvisionAdjustedDates;
        private final CallingPartyEnum callingParty;
        private final PartyRole singlePartyOption;
        private final RelativeDateOffset noticeDeadlinePeriod;
        private final ZonedDateTime noticeDeadlineDateTime;
        private final RelativeDateOffset extensionTerm;
        private final AdjustableRelativeOrPeriodicDates extensionPeriod;

        protected ExtendibleProvisionImpl(ExtendibleProvisionBuilder builder) {
            super(builder);
            this.americanExercise = Optional.ofNullable(builder.getAmericanExercise()).map(f -> f.build()).orElse(null);
            this.bermudaExercise = Optional.ofNullable(builder.getBermudaExercise()).map(f -> f.build()).orElse(null);
            this.europeanExercise = Optional.ofNullable(builder.getEuropeanExercise()).map(f -> f.build()).orElse(null);
            this.exerciseNotice = Optional.ofNullable(builder.getExerciseNotice()).map(f -> f.build()).orElse(null);
            this.followUpConfirmation = builder.getFollowUpConfirmation();
            this.extendibleProvisionAdjustedDates = Optional.ofNullable(builder.getExtendibleProvisionAdjustedDates()).map(f -> f.build()).orElse(null);
            this.callingParty = builder.getCallingParty();
            this.singlePartyOption = Optional.ofNullable(builder.getSinglePartyOption()).map(f -> f.build()).orElse(null);
            this.noticeDeadlinePeriod = Optional.ofNullable(builder.getNoticeDeadlinePeriod()).map(f -> f.build()).orElse(null);
            this.noticeDeadlineDateTime = builder.getNoticeDeadlineDateTime();
            this.extensionTerm = Optional.ofNullable(builder.getExtensionTerm()).map(f -> f.build()).orElse(null);
            this.extensionPeriod = Optional.ofNullable(builder.getExtensionPeriod()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public AmericanExercise getAmericanExercise() {
            return this.americanExercise;
        }

        @Override
        @RosettaAttribute(value="bermudaExercise")
        @RuneAttribute(value="bermudaExercise")
        public BermudaExercise getBermudaExercise() {
            return this.bermudaExercise;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public EuropeanExercise getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public ExerciseNotice getExerciseNotice() {
            return this.exerciseNotice;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation")
        @RuneAttribute(value="followUpConfirmation")
        public Boolean getFollowUpConfirmation() {
            return this.followUpConfirmation;
        }

        @Override
        @RosettaAttribute(value="extendibleProvisionAdjustedDates")
        @RuneAttribute(value="extendibleProvisionAdjustedDates")
        public ExtendibleProvisionAdjustedDates getExtendibleProvisionAdjustedDates() {
            return this.extendibleProvisionAdjustedDates;
        }

        @Override
        @RosettaAttribute(value="callingParty")
        @RuneAttribute(value="callingParty")
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="singlePartyOption")
        @RuneAttribute(value="singlePartyOption")
        public PartyRole getSinglePartyOption() {
            return this.singlePartyOption;
        }

        @Override
        @RosettaAttribute(value="noticeDeadlinePeriod")
        @RuneAttribute(value="noticeDeadlinePeriod")
        public RelativeDateOffset getNoticeDeadlinePeriod() {
            return this.noticeDeadlinePeriod;
        }

        @Override
        @RosettaAttribute(value="noticeDeadlineDateTime")
        @RuneAttribute(value="noticeDeadlineDateTime")
        public ZonedDateTime getNoticeDeadlineDateTime() {
            return this.noticeDeadlineDateTime;
        }

        @Override
        @RosettaAttribute(value="extensionTerm")
        @RuneAttribute(value="extensionTerm")
        public RelativeDateOffset getExtensionTerm() {
            return this.extensionTerm;
        }

        @Override
        @RosettaAttribute(value="extensionPeriod")
        @RuneAttribute(value="extensionPeriod")
        public AdjustableRelativeOrPeriodicDates getExtensionPeriod() {
            return this.extensionPeriod;
        }

        @Override
        public ExtendibleProvision build() {
            return this;
        }

        @Override
        public ExtendibleProvisionBuilder toBuilder() {
            ExtendibleProvisionBuilder builder = ExtendibleProvision.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExtendibleProvisionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmericanExercise()).ifPresent(builder::setAmericanExercise);
            Optional.ofNullable(this.getBermudaExercise()).ifPresent(builder::setBermudaExercise);
            Optional.ofNullable(this.getEuropeanExercise()).ifPresent(builder::setEuropeanExercise);
            Optional.ofNullable(this.getExerciseNotice()).ifPresent(builder::setExerciseNotice);
            Optional.ofNullable(this.getFollowUpConfirmation()).ifPresent(builder::setFollowUpConfirmation);
            Optional.ofNullable(this.getExtendibleProvisionAdjustedDates()).ifPresent(builder::setExtendibleProvisionAdjustedDates);
            Optional.ofNullable(this.getCallingParty()).ifPresent(builder::setCallingParty);
            Optional.ofNullable(this.getSinglePartyOption()).ifPresent(builder::setSinglePartyOption);
            Optional.ofNullable(this.getNoticeDeadlinePeriod()).ifPresent(builder::setNoticeDeadlinePeriod);
            Optional.ofNullable(this.getNoticeDeadlineDateTime()).ifPresent(builder::setNoticeDeadlineDateTime);
            Optional.ofNullable(this.getExtensionTerm()).ifPresent(builder::setExtensionTerm);
            Optional.ofNullable(this.getExtensionPeriod()).ifPresent(builder::setExtensionPeriod);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtendibleProvision _that = (ExtendibleProvision)this.getType().cast(o);
            if (!Objects.equals(this.americanExercise, _that.getAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.bermudaExercise, _that.getBermudaExercise())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseNotice, _that.getExerciseNotice())) {
                return false;
            }
            if (!Objects.equals(this.followUpConfirmation, _that.getFollowUpConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.extendibleProvisionAdjustedDates, _that.getExtendibleProvisionAdjustedDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.singlePartyOption, _that.getSinglePartyOption())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlinePeriod, _that.getNoticeDeadlinePeriod())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlineDateTime, _that.getNoticeDeadlineDateTime())) {
                return false;
            }
            if (!Objects.equals(this.extensionTerm, _that.getExtensionTerm())) {
                return false;
            }
            return Objects.equals(this.extensionPeriod, _that.getExtensionPeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.americanExercise != null ? this.americanExercise.hashCode() : 0);
            _result = 31 * _result + (this.bermudaExercise != null ? this.bermudaExercise.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseNotice != null ? this.exerciseNotice.hashCode() : 0);
            _result = 31 * _result + (this.followUpConfirmation != null ? this.followUpConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.extendibleProvisionAdjustedDates != null ? this.extendibleProvisionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.singlePartyOption != null ? this.singlePartyOption.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlineDateTime != null ? this.noticeDeadlineDateTime.hashCode() : 0);
            _result = 31 * _result + (this.extensionTerm != null ? this.extensionTerm.hashCode() : 0);
            _result = 31 * _result + (this.extensionPeriod != null ? this.extensionPeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExtendibleProvision {americanExercise=" + this.americanExercise + ", bermudaExercise=" + this.bermudaExercise + ", europeanExercise=" + this.europeanExercise + ", exerciseNotice=" + this.exerciseNotice + ", followUpConfirmation=" + this.followUpConfirmation + ", extendibleProvisionAdjustedDates=" + this.extendibleProvisionAdjustedDates + ", callingParty=" + (Object)((Object)this.callingParty) + ", singlePartyOption=" + this.singlePartyOption + ", noticeDeadlinePeriod=" + this.noticeDeadlinePeriod + ", noticeDeadlineDateTime=" + this.noticeDeadlineDateTime + ", extensionTerm=" + this.extensionTerm + ", extensionPeriod=" + this.extensionPeriod + '}' + " " + super.toString();
        }
    }
}

