/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.functions.ExpirationTimeType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="EuropeanExerciseExpirationTimeChoice")
@ImplementedBy(value=Default.class)
public interface EuropeanExerciseExpirationTimeChoice
extends Validator<EuropeanExercise> {
    public static final String NAME = "EuropeanExerciseExpirationTimeChoice";
    public static final String DEFINITION = "ExpirationTimeType(expirationTime, expirationTimeType)";

    public static class NoOp
    implements EuropeanExerciseExpirationTimeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EuropeanExercise europeanExercise) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EuropeanExerciseExpirationTimeChoice {
        @Inject
        protected ExpirationTimeType expirationTimeType;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EuropeanExercise europeanExercise) {
            ComparisonResult result = this.executeDataRule(europeanExercise);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EuropeanExerciseExpirationTimeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EuropeanExercise", (RosettaPath)path, (String)EuropeanExerciseExpirationTimeChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EuropeanExerciseExpirationTimeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EuropeanExercise", (RosettaPath)path, (String)EuropeanExerciseExpirationTimeChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EuropeanExercise europeanExercise) {
            try {
                return ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.expirationTimeType.evaluate((BusinessCenterTime)MapperS.of((Object)europeanExercise).map("getExpirationTime", _europeanExercise -> _europeanExercise.getExpirationTime()).get(), (ExpirationTimeTypeEnum)((Object)MapperS.of((Object)europeanExercise).map("getExpirationTimeType", _europeanExercise -> _europeanExercise.getExpirationTimeType()).get()))));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

