/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.TargetLanguageRepresentation;
import com.rosetta.util.types.JavaArrayType;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaTypeArgumentVisitor;
import com.rosetta.util.types.JavaTypeVariable;
import com.rosetta.util.types.JavaTypeVisitor;
import com.rosetta.util.types.JavaWildcardTypeArgument;
import java.util.List;
import java.util.Objects;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class JavaTypeRepresentation
implements TargetLanguageRepresentation {
    private JavaType type;

    public JavaTypeRepresentation(JavaType type) {
        Objects.requireNonNull(type);
        this.type = type;
    }

    public String toString() {
        return "Repr[" + this.type.toString() + "]";
    }

    @Override
    public void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
        this.type.accept((JavaTypeVisitor)new ConcatenationVisitor(target));
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JavaTypeRepresentation other = (JavaTypeRepresentation)object;
        return Objects.equals(this.type, other.type);
    }

    private static class ConcatenationVisitor
    implements JavaTypeVisitor,
    JavaTypeArgumentVisitor {
        private StringConcatenationClient.TargetStringConcatenation target;

        public ConcatenationVisitor(StringConcatenationClient.TargetStringConcatenation target) {
            this.target = target;
        }

        public void visitType(JavaArrayType type) {
            type.getBaseType().accept((JavaTypeVisitor)this);
            this.target.append((Object)"[]");
        }

        public void visitType(JavaClass<?> type) {
            this.target.append(type);
        }

        public void visitType(JavaParameterizedType<?> type) {
            type.getGenericTypeDeclaration().getBaseType().accept((JavaTypeVisitor)this);
            this.target.append((Object)"<");
            List arguments = type.getArguments();
            if (!arguments.isEmpty()) {
                ((JavaTypeArgument)arguments.get(0)).accept((JavaTypeArgumentVisitor)this);
                for (int i = 1; i < arguments.size(); ++i) {
                    this.target.append((Object)", ");
                    ((JavaTypeArgument)arguments.get(i)).accept((JavaTypeArgumentVisitor)this);
                }
            }
            this.target.append((Object)">");
        }

        public void visitType(JavaPrimitiveType type) {
            this.target.append((Object)type.getSimpleName());
        }

        public void visitType(JavaTypeVariable type) {
            this.target.append((Object)type.getName());
        }

        public void visitNullType() {
            this.target.append((Object)JavaReferenceType.NULL_TYPE.getSimpleName());
        }

        public void visitTypeArgument(JavaWildcardTypeArgument arg) {
            this.target.append((Object)"?");
            if (arg.hasExtendsBound()) {
                this.target.append((Object)" extends ");
                ((JavaReferenceType)arg.getBound().get()).accept((JavaTypeVisitor)this);
            }
            if (arg.hasSuperBound()) {
                this.target.append((Object)" super ");
                ((JavaReferenceType)arg.getBound().get()).accept((JavaTypeVisitor)this);
            }
        }

        public void visitTypeArgument(JavaReferenceType arg) {
            arg.accept((JavaTypeVisitor)this);
        }
    }
}

