/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.util;

import com.google.common.html.HtmlEscapers;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaDefinable;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaSegmentRef;
import com.regnosys.rosetta.rosetta.simple.AnnotationDeepPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationPathExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.References;
import com.regnosys.rosetta.utils.AnnotationPathExpressionUtil;
import jakarta.inject.Inject;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class ModelGeneratorUtil {
    @Inject
    private AnnotationPathExpressionUtil annotationPathUtil;

    public CharSequence javadoc(RosettaNamed named) {
        StringConcatenation _builder = new StringConcatenation();
        String _javadoc = this.javadoc(named, null);
        _builder.append(_javadoc);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private String javadoc(RosettaNamed named, String version) {
        String _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = named instanceof RosettaDefinable ? ((RosettaDefinable)((Object)named)).getDefinition() : "";
        String definition = _xifexpression;
        EList<RosettaDocReference> _xifexpression_1 = null;
        _xifexpression_1 = named instanceof References ? ((References)((Object)named)).getReferences() : CollectionLiterals.emptyList();
        EList<RosettaDocReference> docRef = _xifexpression_1;
        _xblockexpression = this.javadoc(definition, (List<RosettaDocReference>)docRef, version);
        return _xblockexpression;
    }

    public String javadoc(String definition, List<RosettaDocReference> docRef, String version) {
        String _xifexpression = null;
        if (definition == null && docRef.isEmpty() && version == null) {
            _xifexpression = null;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/**");
            _builder.newLine();
            CharSequence _javadocDefinition = this.javadocDefinition(definition);
            _builder.append((Object)_javadocDefinition);
            _builder.newLineIfNotEmpty();
            CharSequence _javadocVersion = this.javadocVersion(version);
            _builder.append((Object)_javadocVersion);
            _builder.newLineIfNotEmpty();
            CharSequence _javadocDocRef = this.javadocDocRef(docRef);
            _builder.append((Object)_javadocDocRef);
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    public CharSequence emptyJavadocWithVersion(String version) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @version ");
        _builder.append(version, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public CharSequence escape(String definition) {
        StringConcatenation _builder = new StringConcatenation();
        if (definition != null && !definition.isEmpty()) {
            String _escape = HtmlEscapers.htmlEscaper().escape(definition);
            _builder.append(_escape);
        }
        return _builder;
    }

    private CharSequence javadocDefinition(String definition) {
        StringConcatenation _builder = new StringConcatenation();
        if (definition != null && !definition.isEmpty()) {
            _builder.append(" * ");
            String _escape = HtmlEscapers.htmlEscaper().escape(definition);
            _builder.append(_escape);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence javadocVersion(String version) {
        StringConcatenation _builder = new StringConcatenation();
        if (version != null && !version.isEmpty()) {
            _builder.append(" * @version ");
            _builder.append(version);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence javadocDocRef(List<RosettaDocReference> references) {
        StringConcatenation _builder = new StringConcatenation();
        if (references != null && !references.isEmpty()) {
            for (RosettaDocReference reference : references) {
                boolean _tripleNotEquals;
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                AnnotationPathExpression _path = reference.getPath();
                boolean bl = _tripleNotEquals = _path != null;
                if (_tripleNotEquals) {
                    _builder.append(" * ");
                    String _javadocPath = this.javadocPath(reference.getPath());
                    _builder.append(_javadocPath);
                }
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("* Body ");
                String _name = reference.getDocReference().getBody().getName();
                _builder.append(_name, " ");
                _builder.newLineIfNotEmpty();
                EList<RosettaCorpus> _corpusList = reference.getDocReference().getCorpusList();
                for (RosettaCorpus mandate : _corpusList) {
                    boolean _tripleNotEquals_2;
                    boolean _tripleNotEquals_1;
                    _builder.append(" * Corpus ");
                    String _corpusType = mandate.getCorpusType();
                    _builder.append(_corpusType);
                    _builder.append(" ");
                    String _name_1 = mandate.getName();
                    _builder.append(_name_1);
                    _builder.append(" ");
                    String _displayName = mandate.getDisplayName();
                    boolean bl2 = _tripleNotEquals_1 = _displayName != null;
                    if (_tripleNotEquals_1) {
                        String _escape = HtmlEscapers.htmlEscaper().escape(mandate.getDisplayName());
                        _builder.append(_escape);
                    }
                    _builder.append(" ");
                    String _definition = mandate.getDefinition();
                    boolean bl3 = _tripleNotEquals_2 = _definition != null;
                    if (_tripleNotEquals_2) {
                        _builder.append("\"");
                        String _escape_1 = HtmlEscapers.htmlEscaper().escape(mandate.getDefinition());
                        _builder.append(_escape_1);
                        _builder.append("\"");
                    }
                    _builder.append(" ");
                }
                _builder.newLineIfNotEmpty();
                EList<RosettaSegmentRef> _segments = reference.getDocReference().getSegments();
                for (RosettaSegmentRef segment : _segments) {
                    _builder.append(" * ");
                    String _name_2 = segment.getSegment().getName();
                    _builder.append(_name_2);
                    _builder.append(" \"");
                    String _escape_2 = HtmlEscapers.htmlEscaper().escape(segment.getSegmentRef());
                    _builder.append(_escape_2);
                    _builder.append("\"");
                }
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Provision ");
                String _provision = reference.getProvision();
                _builder.append(_provision, " ");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
            }
        }
        return _builder;
    }

    private String javadocPath(AnnotationPathExpression expr) {
        Function<Attribute, String> _function = a -> {
            StringConcatenation _builder = new StringConcatenation();
            String _name = a.getName();
            _builder.append(_name);
            return _builder.toString();
        };
        Function<Attribute, String> _function_1 = a -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("item");
            return _builder.toString();
        };
        BiFunction<String, AnnotationPath, String> _function_2 = (r, p) -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(r);
            _builder.append(" -> ");
            String _name = p.getAttribute().getName();
            _builder.append(_name);
            return _builder.toString();
        };
        BiFunction<String, AnnotationDeepPath, String> _function_3 = (r, dp) -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(r);
            _builder.append(" ->> ");
            String _name = dp.getAttribute().getName();
            _builder.append(_name);
            return _builder.toString();
        };
        return this.annotationPathUtil.fold(expr, _function, _function_1, _function_2, _function_3);
    }
}

