/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import com.regnosys.rosetta.validation.WarningSuppressionHelper;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ConditionValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RosettaEcoreUtil rosettaEcoreUtil;
    @Inject
    private ExpressionHelper exprHelper;
    @Inject
    private WarningSuppressionHelper warningSuppressionHelper;

    @Check
    public void checkConditionName(Condition condition) {
        if (condition.getName() == null && !this.rosettaEcoreUtil.isConstraintCondition(condition)) {
            this.warning("Condition name should be specified", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidName", new String[0]);
        } else {
            boolean suppressed = this.warningSuppressionHelper.isCapitalisationSuppressed(condition);
            if (!suppressed && condition.getName() != null && Character.isLowerCase(condition.getName().charAt(0))) {
                this.warning("Condition name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
            }
        }
    }

    @Check
    public void checkConditionDontUseOutput(Function ele) {
        for (Condition cond : ele.getConditions()) {
            Stack<String> trace;
            List<RosettaSymbol> outRef;
            RosettaExpression expr;
            if (cond.isPostCondition() || (expr = cond.getExpression()) == null || (outRef = this.exprHelper.findOutputRef(expr, trace = new Stack<String>())) == null || outRef.isEmpty()) continue;
            RosettaSymbol first = outRef.get(0);
            StringBuilder msg = new StringBuilder();
            msg.append("output '").append(first.getName()).append("' or alias on output '").append(first.getName()).append("' not allowed in condition blocks.");
            if (!trace.isEmpty()) {
                msg.append("\n").append(String.join((CharSequence)" > ", trace)).append(" > ").append(first.getName());
            }
            this.error(msg.toString(), expr, null);
        }
    }
}

