/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.rosetta.RosettaNamed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CycleValidationHelper {
    public <T extends RosettaNamed> void detectCycle(T object, Function<T, T> nextGetter, String delimiter, Consumer<String> onCycle) {
        this.doDetectCycles(object, this.wrapNull(nextGetter), next -> next, delimiter, (obj, path) -> onCycle.accept((String)path));
    }

    public <T extends RosettaNamed, U> void detectMultipleCycles(T object, Function<T, Iterable<U>> inclusionGetter, Function<U, T> nextGetter, String delimiter, BiConsumer<U, String> onCycle) {
        this.doDetectCycles(object, inclusionGetter, nextGetter, delimiter, onCycle);
    }

    private <T> Function<T, Iterable<T>> wrapNull(Function<T, T> nextGetter) {
        return t -> {
            Object next = nextGetter.apply(t);
            if (next == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(next);
        };
    }

    private <T extends RosettaNamed, U> void doDetectCycles(T object, Function<T, Iterable<U>> inclusionGetter, Function<U, T> nextGetter, String delimiter, BiConsumer<U, String> onCycle) {
        for (U inclusion : inclusionGetter.apply(object)) {
            RosettaNamed next = (RosettaNamed)nextGetter.apply(inclusion);
            ArrayList<T> path = new ArrayList<T>();
            path.add(object);
            HashSet<T> visited = new HashSet<T>();
            visited.add(object);
            if (!this.hasCycle(next, path, visited, inclusionGetter, nextGetter)) continue;
            String pathString = path.stream().map(RosettaNamed::getName).collect(Collectors.joining(" " + delimiter + " "));
            onCycle.accept((String)inclusion, pathString);
        }
    }

    private <T, U> boolean hasCycle(T current, List<T> path, Set<T> visited, Function<T, Iterable<U>> inclusionGetter, Function<U, T> nextGetter) {
        path.add(current);
        if (visited.add(current)) {
            for (U inclusion : inclusionGetter.apply(current)) {
                T next = nextGetter.apply(inclusion);
                if (!this.hasCycle(next, path, visited, inclusionGetter, nextGetter)) continue;
                return true;
            }
        } else if (path.get(0).equals(path.get(path.size() - 1))) {
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }
}

