package drr.base.qualification.product.functions;

import cdm.product.template.ContractualProduct;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsProductOTC.IsProductOTCDefault.class)
public abstract class IsProductOTC implements RosettaFunction {

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	public static class IsProductOTCDefault extends IsProductOTC {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			result = exists(MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct())).get();
			
			return result;
		}
	}
}
