package drr.regulation.common.functions;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.product.asset.ForeignExchange;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.util.datetime.functions.AdjustableOrAdjustedOrRelativeDateResolution;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(FXNearLeg.FXNearLegDefault.class)
public abstract class FXNearLeg implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustableOrAdjustedOrRelativeDateResolution adjustableOrAdjustedOrRelativeDateResolution;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
	@Inject protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;

	/**
	* @param product 
	* @return nearLegPayout 
	*/
	public ForwardPayout evaluate(Product product) {
		ForwardPayout.ForwardPayoutBuilder nearLegPayoutBuilder = doEvaluate(product);
		
		final ForwardPayout nearLegPayout;
		if (nearLegPayoutBuilder == null) {
			nearLegPayout = null;
		} else {
			nearLegPayout = nearLegPayoutBuilder.build();
			objectValidator.validate(ForwardPayout.class, nearLegPayout);
		}
		
		return nearLegPayout;
	}

	protected abstract ForwardPayout.ForwardPayoutBuilder doEvaluate(Product product);

	protected abstract MapperC<? extends ForwardPayout> forwardPayout(Product product);

	public static class FXNearLegDefault extends FXNearLeg {
		@Override
		protected ForwardPayout.ForwardPayoutBuilder doEvaluate(Product product) {
			ForwardPayout.ForwardPayoutBuilder nearLegPayout = ForwardPayout.builder();
			return assignOutput(nearLegPayout, product);
		}
		
		protected ForwardPayout.ForwardPayoutBuilder assignOutput(ForwardPayout.ForwardPayoutBuilder nearLegPayout, Product product) {
			if (ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTermsForProduct.evaluate(product))))).andNullSafe(exists(forwardPayout(product).<SettlementTerms>map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate()))).getOrDefault(false)) {
				nearLegPayout = toBuilder(forwardPayout(product)
					.min(item -> item.<SettlementTerms>map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())).get());
			} else if (ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTermsForProduct.evaluate(product))))).andNullSafe(exists(forwardPayout(product).<Product>map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", _product -> _product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<SettlementTerms>map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<AdjustableOrAdjustedOrRelativeDate>map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()))).getOrDefault(false)) {
				nearLegPayout = toBuilder(forwardPayout(product)
					.min(item -> MapperS.of(adjustableOrAdjustedOrRelativeDateResolution.evaluate(item.<Product>map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", _product -> _product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<SettlementTerms>map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<AdjustableOrAdjustedOrRelativeDate>map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()).get()))).get());
			} else {
				nearLegPayout = null;
			}
			
			return Optional.ofNullable(nearLegPayout)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends ForwardPayout> forwardPayout(Product product) {
			return MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout());
		}
	}
}
