package drr.regulation.common.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(RegimePartySupervisoryBody.RegimePartySupervisoryBodyDefault.class)
public abstract class RegimePartySupervisoryBody implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param regimePartyInformation 
	* @param supervisoryBody 
	* @return partyReference 
	*/
	public List<? extends Party> evaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum supervisoryBody) {
		List<Party.PartyBuilder> partyReferenceBuilder = doEvaluate(regimePartyInformation, supervisoryBody);
		
		final List<? extends Party> partyReference;
		if (partyReferenceBuilder == null) {
			partyReference = null;
		} else {
			partyReference = partyReferenceBuilder.stream().map(Party::build).collect(Collectors.toList());
			objectValidator.validate(Party.class, partyReference);
		}
		
		return partyReference;
	}

	protected abstract List<Party.PartyBuilder> doEvaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum supervisoryBody);

	public static class RegimePartySupervisoryBodyDefault extends RegimePartySupervisoryBody {
		@Override
		protected List<Party.PartyBuilder> doEvaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum supervisoryBody) {
			if (regimePartyInformation == null) {
				regimePartyInformation = Collections.emptyList();
			}
			List<Party.PartyBuilder> partyReference = new ArrayList<>();
			return assignOutput(partyReference, regimePartyInformation, supervisoryBody);
		}
		
		protected List<Party.PartyBuilder> assignOutput(List<Party.PartyBuilder> partyReference, List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum supervisoryBody) {
			final MapperC<RegimePartyInformation> thenArg0 = MapperC.<RegimePartyInformation>of(regimePartyInformation);
			final MapperC<RegimePartyInformation> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<ReportingRegime>mapC("getRegimeInformation", _regimePartyInformation -> _regimePartyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(supervisoryBody), CardinalityOperator.Any).get());
			partyReference = toBuilder(thenArg1
				.mapItem(item -> item.<ReferenceWithMetaParty>map("getPartyReference", _regimePartyInformation -> _regimePartyInformation.getPartyReference())).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty.getValue()).getMulti());
			
			return Optional.ofNullable(partyReference)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
