package drr.regulation.common.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.validation.RegimePartyInformationTypeFormatValidator;
import drr.regulation.common.validation.RegimePartyInformationValidator;
import drr.regulation.common.validation.exists.RegimePartyInformationOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 7.0.0-dev.92
 */
@RosettaMeta(model=RegimePartyInformation.class)
public class RegimePartyInformationMeta implements RosettaMetaData<RegimePartyInformation> {

	@Override
	public List<Validator<? super RegimePartyInformation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super RegimePartyInformation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super RegimePartyInformation> validator(ValidatorFactory factory) {
		return factory.<RegimePartyInformation>create(RegimePartyInformationValidator.class);
	}

	@Override
	public Validator<? super RegimePartyInformation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<RegimePartyInformation>create(RegimePartyInformationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super RegimePartyInformation> validator() {
		return new RegimePartyInformationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super RegimePartyInformation> typeFormatValidator() {
		return new RegimePartyInformationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super RegimePartyInformation, Set<String>> onlyExistsValidator() {
		return new RegimePartyInformationOnlyExistsValidator();
	}
}
