package drr.regulation.common.trade.party.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsCleared;
import drr.base.trade.ReportingSide;
import drr.regulation.common.CFTCFinancialEntityClassificationEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SECPartyInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.party.functions.ExtractRegimeInformation;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Counterparty1FinancialEntityIndicatorRule.Counterparty1FinancialEntityIndicatorRuleDefault.class)
public abstract class Counterparty1FinancialEntityIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractRegimeInformation extractRegimeInformation;
	@Inject protected IsCleared isCleared;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class Counterparty1FinancialEntityIndicatorRuleDefault extends Counterparty1FinancialEntityIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperC<ReportingRegime> thenArg;
			if (areEqual(MapperS.of(isCleared.evaluate(MapperS.of(input).<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
				thenArg = MapperS.of(input)
					.mapSingleToList(item -> {
						final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
						return MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue())));
					});
			} else {
				thenArg = MapperC.<ReportingRegime>ofNull();
			}
			final MapperS<Boolean> ifThenElseResult;
			if (exists(thenArg.<SECPartyInformation>map("getSecPartyInformation", reportingRegime -> reportingRegime.getSecPartyInformation()).<CFTCFinancialEntityClassificationEnum>map("getFinancialEntity", sECPartyInformation -> sECPartyInformation.getFinancialEntity())).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(true);
			} else {
				ifThenElseResult = MapperS.of(false);
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
