package drr.regulation.common.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ESMAPartyInformation;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ESMAPartyInformationTypeFormatValidator implements Validator<ESMAPartyInformation> {

	private List<ComparisonResult> getComparisonResults(ESMAPartyInformation o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAPartyInformation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ESMAPartyInformation", ValidationResult.ValidationType.TYPE_FORMAT, "ESMAPartyInformation", path, "", res.getError());
				}
				return success("ESMAPartyInformation", ValidationResult.ValidationType.TYPE_FORMAT, "ESMAPartyInformation", path, "");
			})
			.collect(toList());
	}

}
