package drr.regulation.common.validation.datarule;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.trade.PartyInformation;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.functions.EqualParty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 7.0.0-dev.92
 */
@RosettaDataRule("ReportableInformationEqualParty")
@ImplementedBy(ReportableInformationEqualParty.Default.class)
public interface ReportableInformationEqualParty extends Validator<ReportableInformation> {
	
	String NAME = "ReportableInformationEqualParty";
	String DEFINITION = "EqualParty( partyInformation -> partyReference, regimePartyInformation -> partyReference )";
	
	class Default implements ReportableInformationEqualParty {
	
		@Inject protected EqualParty equalParty;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportableInformation reportableInformation) {
			ComparisonResult result = executeDataRule(reportableInformation);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportableInformation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportableInformation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ReportableInformation reportableInformation) {
			try {
				return ComparisonResult.ofNullSafe(MapperS.of(equalParty.evaluate(MapperS.of(reportableInformation).<PartyInformation>mapC("getPartyInformation", _reportableInformation -> _reportableInformation.getPartyInformation()).<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty.getValue()).getMulti(), MapperS.of(reportableInformation).<RegimePartyInformation>mapC("getRegimePartyInformation", _reportableInformation -> _reportableInformation.getRegimePartyInformation()).<ReferenceWithMetaParty>map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty.getValue()).getMulti())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ReportableInformationEqualParty {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportableInformation reportableInformation) {
			return Collections.emptyList();
		}
	}
}
