package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CSAPartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 7.0.0-dev.92
 */
@RosettaDataRule("ReportingRegimeCSAReportingRegime")
@ImplementedBy(ReportingRegimeCSAReportingRegime.Default.class)
public interface ReportingRegimeCSAReportingRegime extends Validator<ReportingRegime> {
	
	String NAME = "ReportingRegimeCSAReportingRegime";
	String DEFINITION = "if csaTrade.SupervisoryBodyForCSA any = supervisoryBody then csaPartyInformation exists else csaPartyInformation is absent";
	
	class Default implements ReportingRegimeCSAReportingRegime {
	
		@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			ComparisonResult result = executeDataRule(reportingRegime);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ReportingRegime reportingRegime) {
			try {
				if (areEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), MapperS.of(reportingRegime).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _reportingRegime -> _reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), CardinalityOperator.Any).getOrDefault(false)) {
					return exists(MapperS.of(reportingRegime).<CSAPartyInformation>map("getCsaPartyInformation", _reportingRegime -> _reportingRegime.getCsaPartyInformation()));
				}
				return notExists(MapperS.of(reportingRegime).<CSAPartyInformation>map("getCsaPartyInformation", _reportingRegime -> _reportingRegime.getCsaPartyInformation()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ReportingRegimeCSAReportingRegime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			return Collections.emptyList();
		}
	}
}
