package drr.regulation.csa.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CSAPartyInformation;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PortfolioContainingNonReportableComponentIndicatorRule.PortfolioContainingNonReportableComponentIndicatorRuleDefault.class)
public abstract class PortfolioContainingNonReportableComponentIndicatorRule implements ReportFunction<CollateralReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(CollateralReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(CollateralReportInstruction input);

	public static class PortfolioContainingNonReportableComponentIndicatorRuleDefault extends PortfolioContainingNonReportableComponentIndicatorRule {
		@Override
		protected Boolean doEvaluate(CollateralReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, CollateralReportInstruction input) {
			final MapperC<RegimePartyInformation> thenArg0 = MapperS.of(input)
				.mapSingleToList(item -> item.<ReportableInformation>map("getReportableInformation", collateralReportInstruction -> collateralReportInstruction.getReportableInformation()).<RegimePartyInformation>mapC("getRegimePartyInformation", reportableInformation -> reportableInformation.getRegimePartyInformation()));
			final MapperListOfLists<ReportingRegime> thenArg1 = thenArg0
				.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", regimePartyInformation -> regimePartyInformation.getRegimeInformation()));
			final MapperC<ReportingRegime> thenArg2 = thenArg1
				.flattenList();
			final MapperC<ReportingRegime> thenArg3 = thenArg2
				.filterItemNullSafe(item -> areEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), CardinalityOperator.Any).get());
			final MapperS<ReportingRegime> thenArg4 = MapperS.of(thenArg3.get());
			output = thenArg4
				.mapSingleToItem(item -> {
					if (exists(item.<CSAPartyInformation>map("getCsaPartyInformation", reportingRegime -> reportingRegime.getCsaPartyInformation()).<Boolean>map("getNonReportedTradePortfolio", cSAPartyInformation -> cSAPartyInformation.getNonReportedTradePortfolio())).getOrDefault(false)) {
						return item.<CSAPartyInformation>map("getCsaPartyInformation", reportingRegime -> reportingRegime.getCsaPartyInformation()).<Boolean>map("getNonReportedTradePortfolio", cSAPartyInformation -> cSAPartyInformation.getNonReportedTradePortfolio());
					}
					return MapperS.of(false);
				}).get();
			
			return output;
		}
	}
}
