package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.base.trade.ReportingSide;
import drr.regulation.common.FCAPartyInformation;
import drr.regulation.common.NatureOfPartyEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractNatureOfCounterparty;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.party.functions.ExtractRegimeInformation;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NatureOfTheCounterparty2Rule.NatureOfTheCounterparty2RuleDefault.class)
public abstract class NatureOfTheCounterparty2Rule implements ReportFunction<TransactionReportInstruction, NatureOfCounterpartyEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractNatureOfCounterparty extractNatureOfCounterparty;
	@Inject protected ExtractRegimeInformation extractRegimeInformation;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public NatureOfCounterpartyEnum evaluate(TransactionReportInstruction input) {
		NatureOfCounterpartyEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract NatureOfCounterpartyEnum doEvaluate(TransactionReportInstruction input);

	public static class NatureOfTheCounterparty2RuleDefault extends NatureOfTheCounterparty2Rule {
		@Override
		protected NatureOfCounterpartyEnum doEvaluate(TransactionReportInstruction input) {
			NatureOfCounterpartyEnum output = null;
			return assignOutput(output, input);
		}
		
		protected NatureOfCounterpartyEnum assignOutput(NatureOfCounterpartyEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).get();
					final MapperC<NatureOfPartyEnum> _thenArg = MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()))).<FCAPartyInformation>map("getFcaPartyInformation", reportingRegime -> reportingRegime.getFcaPartyInformation()).<NatureOfPartyEnum>map("getNatureOfParty", fCAPartyInformation -> fCAPartyInformation.getNatureOfParty());
					return MapperS.of(extractNatureOfCounterparty.evaluate(MapperS.of(distinct(_thenArg).get()).get()));
				}).get();
			
			return output;
		}
	}
}
