package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.price.PriceNotationEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.standards.iosco.cde.version3.price.reports.SpreadNotationEnumRule;
import javax.inject.Inject;


@ImplementedBy(SpreadNotationLeg2Rule.SpreadNotationLeg2RuleDefault.class)
public abstract class SpreadNotationLeg2Rule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected DefaultPercentageToDecimal defaultPercentageToDecimal;
	@Inject protected PayoutLeg2Rule payoutLeg2Rule;
	@Inject protected SpreadNotationEnumRule spreadNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadNotationLeg2RuleDefault extends SpreadNotationLeg2Rule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(defaultPercentageToDecimal.evaluate(spreadNotationEnumRule.evaluate(payoutLeg2Rule.evaluate(item.get())), false))).get();
			
			return output;
		}
	}
}
