package drr.regulation.sec.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 7.0.0-dev.92
 */
@RosettaDataRule("SECTransactionReportDTCC_SEC_VR_ClearingSwapUSIID")
@ImplementedBy(SECTransactionReportDTCC_SEC_VR_ClearingSwapUSIID.Default.class)
public interface SECTransactionReportDTCC_SEC_VR_ClearingSwapUSIID extends Validator<SECTransactionReport> {
	
	String NAME = "SECTransactionReportDTCC_SEC_VR_ClearingSwapUSIID";
	String DEFINITION = "if (cleared = Y or (cleared = I and actionType = TERM)) and [EventTypeEnum -> CLRG, EventTypeEnum -> CLAL] any = eventType and clearingSwapUTIs is absent then clearingSwapUSIs exists";
	
	class Default implements SECTransactionReportDTCC_SEC_VR_ClearingSwapUSIID {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			ComparisonResult result = executeDataRule(sECTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SECTransactionReport sECTransactionReport) {
			try {
				if (areEqual(MapperS.of(sECTransactionReport).<ClearedEnum>map("getCleared", _sECTransactionReport -> _sECTransactionReport.getCleared()), MapperS.of(ClearedEnum.Y), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(sECTransactionReport).<ClearedEnum>map("getCleared", _sECTransactionReport -> _sECTransactionReport.getCleared()), MapperS.of(ClearedEnum.I), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(sECTransactionReport).<ActionTypeEnum>map("getActionType", _sECTransactionReport -> _sECTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.TERM), CardinalityOperator.All))).andNullSafe(areEqual(MapperC.<EventTypeEnum>of(MapperS.of(EventTypeEnum.CLRG), MapperS.of(EventTypeEnum.CLAL)), MapperS.of(sECTransactionReport).<EventTypeEnum>map("getEventType", _sECTransactionReport -> _sECTransactionReport.getEventType()), CardinalityOperator.Any)).andNullSafe(notExists(MapperS.of(sECTransactionReport).<String>mapC("getClearingSwapUTIs", _sECTransactionReport -> _sECTransactionReport.getClearingSwapUTIs()))).getOrDefault(false)) {
					return exists(MapperS.of(sECTransactionReport).<String>mapC("getClearingSwapUSIs", _sECTransactionReport -> _sECTransactionReport.getClearingSwapUSIs()));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SECTransactionReportDTCC_SEC_VR_ClearingSwapUSIID {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			return Collections.emptyList();
		}
	}
}
