package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.quantity.functions.GetTradeForQuantity;
import drr.standards.iosco.cde.version1.quantity.functions.OptionAmountAndCurrency;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(CallAmountRule.CallAmountRuleDefault.class)
public abstract class CallAmountRule implements ReportFunction<TransactionReportInstructionBase, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected GetTradeForQuantity getTradeForQuantity;
	@Inject protected IsFXOption isFXOption;
	@Inject protected OptionAmountAndCurrency optionAmountAndCurrency;
	@Inject protected ProductForTrade productForTrade;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstructionBase input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase input);

	public static class CallAmountRuleDefault extends CallAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstructionBase input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstructionBase input) {
			final MapperS<Product> thenArg0 = MapperS.of(productForTrade.evaluate(getTradeForQuantity.evaluate(input)));
			final MapperS<Product> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> isFXOption.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg2 = MapperS.of(optionAmountAndCurrency.evaluate(MapperS.of(economicTermsForProduct.evaluate(thenArg1.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get(), OptionTypeCode.CALL)).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
