package drr.standards.iosco.cde.version3.underlier.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.qualification.product.functions.IsIRSwaption;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.base.trade.underlier.functions.UnderlierProductIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UnderlierProductIdentifierOtherRule.UnderlierProductIdentifierOtherRuleDefault.class)
public abstract class UnderlierProductIdentifierOtherRule implements ReportFunction<TransactionReportInstructionBase, List<? extends ProductIdentifier>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;
	@Inject protected UnderlierProductIdentifier underlierProductIdentifier;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends ProductIdentifier> evaluate(TransactionReportInstructionBase input) {
		List<ProductIdentifier.ProductIdentifierBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends ProductIdentifier> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
			objectValidator.validate(ProductIdentifier.class, output);
		}
		
		return output;
	}

	protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(TransactionReportInstructionBase input);

	public static class UnderlierProductIdentifierOtherRuleDefault extends UnderlierProductIdentifierOtherRule {
		@Override
		protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(TransactionReportInstructionBase input) {
			List<ProductIdentifier.ProductIdentifierBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> output, TransactionReportInstructionBase input) {
			final MapperS<Product> thenArg;
			if (ComparisonResult.ofNullSafe(MapperS.of(isCreditSwaption.evaluate(productForEvent.evaluate(input)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isIRSwaption.evaluate(productForEvent.evaluate(input))))).getOrDefault(false)) {
				thenArg = MapperS.of(underlierForProduct.evaluate(productForEvent.evaluate(input)));
			} else {
				thenArg = MapperS.of(productForEvent.evaluate(input));
			}
			output = toBuilder(thenArg
				.mapSingleToList(item -> {
					if (notExists(MapperC.<ProductIdentifier>of(underlierProductIdentifier.evaluate(item.get(), ProductIdTypeEnum.ISIN))).getOrDefault(false)) {
						return MapperC.<ProductIdentifier>of(underlierProductIdentifier.evaluate(item.get(), null));
					}
					return MapperC.<ProductIdentifier>ofNull();
				}).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
