package drr.standards.iosco.cde.version3.underlier.reports;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.asset.CommodityPayout;
import cdm.product.template.Basket;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.ReportableInformationBase;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.functions.TradableProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.base.util.string.functions.StringContains;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.functions.PayoutFromProductLeg1;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UnderlyingAssetTradingPlatformIdentifierLeg1Rule.UnderlyingAssetTradingPlatformIdentifierLeg1RuleDefault.class)
public abstract class UnderlyingAssetTradingPlatformIdentifierLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected PayoutFromProductLeg1 payoutFromProductLeg1;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected StringContains stringContains;
	@Inject protected TradableProductForEvent tradableProductForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class UnderlyingAssetTradingPlatformIdentifierLeg1RuleDefault extends UnderlyingAssetTradingPlatformIdentifierLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<PayoutLegWithAuxiliary> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (lessThanEquals(MapperS.of(MapperS.of(underlierForProduct.evaluate(productForEvent.evaluate(item.get()))).<Basket>map("getBasket", product -> product.getBasket()).<Product>mapC("getBasketConstituent", basket -> basket.getBasketConstituent()).resultCount()), MapperS.of(1), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(payoutFromProductLeg1.evaluate(MapperS.of(tradableProductForEvent.evaluate(item.get())).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), MapperS.of(tradableProductForEvent.evaluate(item.get())).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), item.<ReportableInformationBase>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()));
					}
					return MapperS.<PayoutLegWithAuxiliary>ofNull();
				});
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (exists(item.<OptionPayout>map("getOptionPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getOptionPayout()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier())).getOrDefault(false)) {
						return item.<OptionPayout>map("getOptionPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getOptionPayout()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier());
					}
					if (exists(item.<ForwardPayout>map("getForwardPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier())).getOrDefault(false)) {
						return item.<ForwardPayout>map("getForwardPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getForwardPayout()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier());
					}
					if (exists(item.<PerformancePayout>map("getPerformancePayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier())).getOrDefault(false)) {
						return item.<PerformancePayout>map("getPerformancePayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier());
					}
					if (exists(item.<CommodityPayout>map("getCommodityPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier())).getOrDefault(false)) {
						return item.<CommodityPayout>map("getCommodityPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier());
					}
					return MapperS.<Product>ofNull();
				});
			final MapperS<LegalEntity> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					if (exists(item.<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity0 -> referenceWithMetaCommodity0 == null ? null : referenceWithMetaCommodity0.getValue()).<LegalEntity>map("getExchange", commodity -> commodity.getExchange())).getOrDefault(false)) {
						return item.<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity1 -> referenceWithMetaCommodity1 == null ? null : referenceWithMetaCommodity1.getValue()).<LegalEntity>map("getExchange", commodity -> commodity.getExchange());
					}
					if (exists(item.<Security>map("getSecurity", product -> product.getSecurity()).<LegalEntity>map("getExchange", security -> security.getExchange())).getOrDefault(false)) {
						return item.<Security>map("getSecurity", product -> product.getSecurity()).<LegalEntity>map("getExchange", security -> security.getExchange());
					}
					if (exists(MapperS.of(item.<Basket>map("getBasket", product -> product.getBasket()).<Product>mapC("getBasketConstituent", basket -> basket.getBasketConstituent()).<Security>map("getSecurity", product -> product.getSecurity()).<LegalEntity>map("getExchange", security -> security.getExchange()).get())).getOrDefault(false)) {
						return MapperS.of(item.<Basket>map("getBasket", product -> product.getBasket()).<Product>mapC("getBasketConstituent", basket -> basket.getBasketConstituent()).<Security>map("getSecurity", product -> product.getSecurity()).<LegalEntity>map("getExchange", security -> security.getExchange()).get());
					}
					return MapperS.<LegalEntity>ofNull();
				});
			final MapperC<FieldWithMetaString> thenArg3 = thenArg2
				.mapSingleToList(item -> item.<FieldWithMetaString>mapC("getEntityId", legalEntity -> legalEntity.getEntityId()));
			final MapperC<FieldWithMetaString> thenArg4 = thenArg3
				.filterItemNullSafe(item -> stringContains.evaluate(item.map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()).get(), "http://www.fpml.org/coding-scheme/external/mifir/extension-iso10383"));
			final FieldWithMetaString fieldWithMetaString = thenArg4
				.first().get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
