package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.meta.AgriculturalCommodityForestry2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an agricultural derivative of type forestry.
 * @version ${project.version}
 */
@RosettaDataType(value="AgriculturalCommodityForestry2__1", builder=AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="AgriculturalCommodityForestry2__1", model="iso20022", builder=AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1BuilderImpl.class, version="${project.version}")
public interface AgriculturalCommodityForestry2__1 extends RosettaModelObject {

	AgriculturalCommodityForestry2__1Meta metaData = new AgriculturalCommodityForestry2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType1Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType21Code getSubPdct();

	/*********************** Build Methods  ***********************/
	AgriculturalCommodityForestry2__1 build();
	
	AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder toBuilder();
	
	static AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder builder() {
		return new AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AgriculturalCommodityForestry2__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AgriculturalCommodityForestry2__1> getType() {
		return AgriculturalCommodityForestry2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType21Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface AgriculturalCommodityForestry2__1Builder extends AgriculturalCommodityForestry2__1, RosettaModelObjectBuilder {
		AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder setBasePdct(AssetClassProductType1Code basePdct);
		AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder setSubPdct(AssetClassSubProductType21Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType1Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType21Code.class, getSubPdct(), this);
		}
		

		AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder prune();
	}

	/*********************** Immutable Implementation of AgriculturalCommodityForestry2__1  ***********************/
	class AgriculturalCommodityForestry2__1Impl implements AgriculturalCommodityForestry2__1 {
		private final AssetClassProductType1Code basePdct;
		private final AssetClassSubProductType21Code subPdct;
		
		protected AgriculturalCommodityForestry2__1Impl(AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		public AssetClassSubProductType21Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public AgriculturalCommodityForestry2__1 build() {
			return this;
		}
		
		@Override
		public AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder toBuilder() {
			AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityForestry2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityForestry2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of AgriculturalCommodityForestry2__1  ***********************/
	class AgriculturalCommodityForestry2__1BuilderImpl implements AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder {
	
		protected AssetClassProductType1Code basePdct;
		protected AssetClassSubProductType21Code subPdct;
		
		@Override
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		public AssetClassProductType1Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		public AssetClassSubProductType21Code getSubPdct() {
			return subPdct;
		}
		
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		@Override
		public AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder setBasePdct(AssetClassProductType1Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		@Override
		public AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder setSubPdct(AssetClassSubProductType21Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public AgriculturalCommodityForestry2__1 build() {
			return new AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Impl(this);
		}
		
		@Override
		public AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder o = (AgriculturalCommodityForestry2__1.AgriculturalCommodityForestry2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AgriculturalCommodityForestry2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AgriculturalCommodityForestry2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
