package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.meta.EnergyCommodityOil3__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an energy derivative of type oil.
 * @version ${project.version}
 */
@RosettaDataType(value="EnergyCommodityOil3__1", builder=EnergyCommodityOil3__1.EnergyCommodityOil3__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="EnergyCommodityOil3__1", model="iso20022", builder=EnergyCommodityOil3__1.EnergyCommodityOil3__1BuilderImpl.class, version="${project.version}")
public interface EnergyCommodityOil3__1 extends RosettaModelObject {

	EnergyCommodityOil3__1Meta metaData = new EnergyCommodityOil3__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType2Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType8Code getSubPdct();
	/**
	 * Further subproduct type related to instruments that have a non-financial instrument or commodity as underlying.
	 */
	AssetClassDetailedSubProductType32Code getAddtlSubPdct();

	/*********************** Build Methods  ***********************/
	EnergyCommodityOil3__1 build();
	
	EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder toBuilder();
	
	static EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder builder() {
		return new EnergyCommodityOil3__1.EnergyCommodityOil3__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EnergyCommodityOil3__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends EnergyCommodityOil3__1> getType() {
		return EnergyCommodityOil3__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType8Code.class, getSubPdct(), this);
		processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType32Code.class, getAddtlSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EnergyCommodityOil3__1Builder extends EnergyCommodityOil3__1, RosettaModelObjectBuilder {
		EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder setBasePdct(AssetClassProductType2Code basePdct);
		EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder setSubPdct(AssetClassSubProductType8Code subPdct);
		EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder setAddtlSubPdct(AssetClassDetailedSubProductType32Code addtlSubPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType8Code.class, getSubPdct(), this);
			processor.processBasic(path.newSubPath("addtlSubPdct"), AssetClassDetailedSubProductType32Code.class, getAddtlSubPdct(), this);
		}
		

		EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder prune();
	}

	/*********************** Immutable Implementation of EnergyCommodityOil3__1  ***********************/
	class EnergyCommodityOil3__1Impl implements EnergyCommodityOil3__1 {
		private final AssetClassProductType2Code basePdct;
		private final AssetClassSubProductType8Code subPdct;
		private final AssetClassDetailedSubProductType32Code addtlSubPdct;
		
		protected EnergyCommodityOil3__1Impl(EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
			this.addtlSubPdct = builder.getAddtlSubPdct();
		}
		
		@Override
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		public AssetClassSubProductType8Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute(value="addtlSubPdct", isRequired=true)
		@RuneAttribute(value="addtlSubPdct", isRequired=true)
		public AssetClassDetailedSubProductType32Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@Override
		public EnergyCommodityOil3__1 build() {
			return this;
		}
		
		@Override
		public EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder toBuilder() {
			EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
			ofNullable(getAddtlSubPdct()).ifPresent(builder::setAddtlSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityOil3__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityOil3__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of EnergyCommodityOil3__1  ***********************/
	class EnergyCommodityOil3__1BuilderImpl implements EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder {
	
		protected AssetClassProductType2Code basePdct;
		protected AssetClassSubProductType8Code subPdct;
		protected AssetClassDetailedSubProductType32Code addtlSubPdct;
		
		@Override
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		public AssetClassSubProductType8Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute(value="addtlSubPdct", isRequired=true)
		@RuneAttribute(value="addtlSubPdct", isRequired=true)
		public AssetClassDetailedSubProductType32Code getAddtlSubPdct() {
			return addtlSubPdct;
		}
		
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		@Override
		public EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder setBasePdct(AssetClassProductType2Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		@Override
		public EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder setSubPdct(AssetClassSubProductType8Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@RosettaAttribute(value="addtlSubPdct", isRequired=true)
		@RuneAttribute(value="addtlSubPdct", isRequired=true)
		@Override
		public EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder setAddtlSubPdct(AssetClassDetailedSubProductType32Code _addtlSubPdct) {
			this.addtlSubPdct = _addtlSubPdct == null ? null : _addtlSubPdct;
			return this;
		}
		
		@Override
		public EnergyCommodityOil3__1 build() {
			return new EnergyCommodityOil3__1.EnergyCommodityOil3__1Impl(this);
		}
		
		@Override
		public EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			if (getAddtlSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder o = (EnergyCommodityOil3__1.EnergyCommodityOil3__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			merger.mergeBasic(getAddtlSubPdct(), o.getAddtlSubPdct(), this::setAddtlSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityOil3__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			if (!Objects.equals(addtlSubPdct, _that.getAddtlSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (addtlSubPdct != null ? addtlSubPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityOil3__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct + ", " +
				"addtlSubPdct=" + this.addtlSubPdct +
			'}';
		}
	}
}
