package iso20022.auth030.hkma.tr;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.tr.meta.AmountAndDirection106__3Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Posting of an item to a cash account, in the context of a cash transaction, that results in an increase or decrease to the balance of the account.
 * @version ${project.version}
 */
@RosettaDataType(value="AmountAndDirection106__3", builder=AmountAndDirection106__3.AmountAndDirection106__3BuilderImpl.class, version="${project.version}")
@RuneDataType(value="AmountAndDirection106__3", model="iso20022", builder=AmountAndDirection106__3.AmountAndDirection106__3BuilderImpl.class, version="${project.version}")
public interface AmountAndDirection106__3 extends RosettaModelObject {

	AmountAndDirection106__3Meta metaData = new AmountAndDirection106__3Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Amount of money in the cash entry.
	 */
	ActiveOrHistoricCurrencyAnd5DecimalAmount getAmt();

	/*********************** Build Methods  ***********************/
	AmountAndDirection106__3 build();
	
	AmountAndDirection106__3.AmountAndDirection106__3Builder toBuilder();
	
	static AmountAndDirection106__3.AmountAndDirection106__3Builder builder() {
		return new AmountAndDirection106__3.AmountAndDirection106__3BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends AmountAndDirection106__3> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends AmountAndDirection106__3> getType() {
		return AmountAndDirection106__3.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("amt"), processor, ActiveOrHistoricCurrencyAnd5DecimalAmount.class, getAmt());
	}
	

	/*********************** Builder Interface  ***********************/
	interface AmountAndDirection106__3Builder extends AmountAndDirection106__3, RosettaModelObjectBuilder {
		ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getOrCreateAmt();
		@Override
		ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getAmt();
		AmountAndDirection106__3.AmountAndDirection106__3Builder setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount amt);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("amt"), processor, ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder.class, getAmt());
		}
		

		AmountAndDirection106__3.AmountAndDirection106__3Builder prune();
	}

	/*********************** Immutable Implementation of AmountAndDirection106__3  ***********************/
	class AmountAndDirection106__3Impl implements AmountAndDirection106__3 {
		private final ActiveOrHistoricCurrencyAnd5DecimalAmount amt;
		
		protected AmountAndDirection106__3Impl(AmountAndDirection106__3.AmountAndDirection106__3Builder builder) {
			this.amt = ofNullable(builder.getAmt()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="amt", isRequired=true)
		@RuneAttribute(value="amt", isRequired=true)
		public ActiveOrHistoricCurrencyAnd5DecimalAmount getAmt() {
			return amt;
		}
		
		@Override
		public AmountAndDirection106__3 build() {
			return this;
		}
		
		@Override
		public AmountAndDirection106__3.AmountAndDirection106__3Builder toBuilder() {
			AmountAndDirection106__3.AmountAndDirection106__3Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(AmountAndDirection106__3.AmountAndDirection106__3Builder builder) {
			ofNullable(getAmt()).ifPresent(builder::setAmt);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AmountAndDirection106__3 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AmountAndDirection106__3 {" +
				"amt=" + this.amt +
			'}';
		}
	}

	/*********************** Builder Implementation of AmountAndDirection106__3  ***********************/
	class AmountAndDirection106__3BuilderImpl implements AmountAndDirection106__3.AmountAndDirection106__3Builder {
	
		protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder amt;
		
		@Override
		@RosettaAttribute(value="amt", isRequired=true)
		@RuneAttribute(value="amt", isRequired=true)
		public ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getAmt() {
			return amt;
		}
		
		@Override
		public ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder getOrCreateAmt() {
			ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder result;
			if (amt!=null) {
				result = amt;
			}
			else {
				result = amt = ActiveOrHistoricCurrencyAnd5DecimalAmount.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="amt", isRequired=true)
		@RuneAttribute(value="amt", isRequired=true)
		@Override
		public AmountAndDirection106__3.AmountAndDirection106__3Builder setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount _amt) {
			this.amt = _amt == null ? null : _amt.toBuilder();
			return this;
		}
		
		@Override
		public AmountAndDirection106__3 build() {
			return new AmountAndDirection106__3.AmountAndDirection106__3Impl(this);
		}
		
		@Override
		public AmountAndDirection106__3.AmountAndDirection106__3Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AmountAndDirection106__3.AmountAndDirection106__3Builder prune() {
			if (amt!=null && !amt.prune().hasData()) amt = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getAmt()!=null && getAmt().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public AmountAndDirection106__3.AmountAndDirection106__3Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			AmountAndDirection106__3.AmountAndDirection106__3Builder o = (AmountAndDirection106__3.AmountAndDirection106__3Builder) other;
			
			merger.mergeRosetta(getAmt(), o.getAmt(), this::setAmt);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			AmountAndDirection106__3 _that = getType().cast(o);
		
			if (!Objects.equals(amt, _that.getAmt())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (amt != null ? amt.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "AmountAndDirection106__3Builder {" +
				"amt=" + this.amt +
			'}';
		}
	}
}
