package iso20022.auth108.iso.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.iso.LegalPersonIdentification1;
import iso20022.auth108.iso.OrganisationIdentification15Choice;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class LegalPersonIdentification1Validator implements Validator<LegalPersonIdentification1> {

	private List<ComparisonResult> getComparisonResults(LegalPersonIdentification1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("id", (OrganisationIdentification15Choice) o.getId() != null ? 1 : 0, 1, 1), 
				checkCardinality("ctry", (String) o.getCtry() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalPersonIdentification1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("LegalPersonIdentification1", ValidationResult.ValidationType.CARDINALITY, "LegalPersonIdentification1", path, "", res.getError());
				}
				return success("LegalPersonIdentification1", ValidationResult.ValidationType.CARDINALITY, "LegalPersonIdentification1", path, "");
			})
			.collect(toList());
	}

}
