package iso20022.dtcc.rds.harmonized.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class HarmonizedDataOnlyExistsValidator implements ValidatorWithArg<HarmonizedData, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends HarmonizedData> ValidationResult<HarmonizedData> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("leg2CommodityInstrumentId", ExistenceChecker.isSet((String) o.getLeg2CommodityInstrumentId()))
				.put("leg2CommodityUnderlyerId", ExistenceChecker.isSet((String) o.getLeg2CommodityUnderlyerId()))
				.put("leg2CommodityUnderlyerDetails", ExistenceChecker.isSet((String) o.getLeg2CommodityUnderlyerDetails()))
				.put("leg2CommodityUnitOfMeasure", ExistenceChecker.isSet((String) o.getLeg2CommodityUnitOfMeasure()))
				.put("leg2CommodityCurrency", ExistenceChecker.isSet((String) o.getLeg2CommodityCurrency()))
				.put("leg2CommodityExchangeId", ExistenceChecker.isSet((String) o.getLeg2CommodityExchangeId()))
				.put("leg1CommodityRateSource", ExistenceChecker.isSet((String) o.getLeg1CommodityRateSource()))
				.put("leg1CommodityRateSourcePage", ExistenceChecker.isSet((String) o.getLeg1CommodityRateSourcePage()))
				.put("leg2SpecifiedPrice", ExistenceChecker.isSet((String) o.getLeg2SpecifiedPrice()))
				.put("commencementDateUnadjusted", ExistenceChecker.isSet((Date) o.getCommencementDateUnadjusted()))
				.put("exerciseExpirationDateUnadjusted", ExistenceChecker.isSet((Date) o.getExerciseExpirationDateUnadjusted()))
				.put("expirationDateUnadjusted", ExistenceChecker.isSet((Date) o.getExpirationDateUnadjusted()))
				.put("leg2NotionalQuantityFrequency", ExistenceChecker.isSet((String) o.getLeg2NotionalQuantityFrequency()))
				.put("leg2NotionalQuantity", ExistenceChecker.isSet((BigDecimal) o.getLeg2NotionalQuantity()))
				.put("leg2TotalNotionalQuantity", ExistenceChecker.isSet((BigDecimal) o.getLeg2TotalNotionalQuantity()))
				.put("leg2SpreadAmount", ExistenceChecker.isSet((BigDecimal) o.getLeg2SpreadAmount()))
				.put("leg2SpreadCurrency", ExistenceChecker.isSet((String) o.getLeg2SpreadCurrency()))
				.put("scheduledTerminationDateAdjusted", ExistenceChecker.isSet((Date) o.getScheduledTerminationDateAdjusted()))
				.put("leg1PartyPayer", ExistenceChecker.isSet((String) o.getLeg1PartyPayer()))
				.put("leg2PartyPayer", ExistenceChecker.isSet((String) o.getLeg2PartyPayer()))
				.put("leg1CommodityInstrumentId", ExistenceChecker.isSet((String) o.getLeg1CommodityInstrumentId()))
				.put("leg1CommodityUnderlyerId", ExistenceChecker.isSet((String) o.getLeg1CommodityUnderlyerId()))
				.put("leg1CommodityUnitOfMeasure", ExistenceChecker.isSet((String) o.getLeg1CommodityUnitOfMeasure()))
				.put("leg1CommodityExchangeId", ExistenceChecker.isSet((String) o.getLeg1CommodityExchangeId()))
				.put("leg2CommodityRateSource", ExistenceChecker.isSet((String) o.getLeg2CommodityRateSource()))
				.put("leg1EffectiveDateUnadjusted", ExistenceChecker.isSet((Date) o.getLeg1EffectiveDateUnadjusted()))
				.put("leg2EffectiveDateUnadjusted", ExistenceChecker.isSet((Date) o.getLeg2EffectiveDateUnadjusted()))
				.put("coProductType", ExistenceChecker.isSet((String) o.getCoProductType()))
				.put("totalQuantityUnit", ExistenceChecker.isSet((String) o.getTotalQuantityUnit()))
				.put("totalQuantity", ExistenceChecker.isSet((BigDecimal) o.getTotalQuantity()))
				.put("fixedPrice", ExistenceChecker.isSet((BigDecimal) o.getFixedPrice()))
				.put("fixedPriceCurrency", ExistenceChecker.isSet((String) o.getFixedPriceCurrency()))
				.put("leg1NotionalQuantityUnit", ExistenceChecker.isSet((String) o.getLeg1NotionalQuantityUnit()))
				.put("leg1NotionalQuantityFrequency", ExistenceChecker.isSet((String) o.getLeg1NotionalQuantityFrequency()))
				.put("leg1NotionalQuantity", ExistenceChecker.isSet((BigDecimal) o.getLeg1NotionalQuantity()))
				.put("leg1TotalNotionalQuantity", ExistenceChecker.isSet((BigDecimal) o.getLeg1TotalNotionalQuantity()))
				.put("leg1CommodityCurrency", ExistenceChecker.isSet((String) o.getLeg1CommodityCurrency()))
				.put("leg1SpecifiedPrice", ExistenceChecker.isSet((String) o.getLeg1SpecifiedPrice()))
				.put("leg1SpreadCurrency", ExistenceChecker.isSet((String) o.getLeg1SpreadCurrency()))
				.put("leg1SpreadAmount", ExistenceChecker.isSet((BigDecimal) o.getLeg1SpreadAmount()))
				.put("leg2NotionalQuantityUnit", ExistenceChecker.isSet((String) o.getLeg2NotionalQuantityUnit()))
				.put("leg2PartyReceiver", ExistenceChecker.isSet((String) o.getLeg2PartyReceiver()))
				.put("leg1PartyReceiver", ExistenceChecker.isSet((String) o.getLeg1PartyReceiver()))
				.put("coalSource", ExistenceChecker.isSet((String) o.getCoalSource()))
				.put("leg2Quantity", ExistenceChecker.isSet((BigDecimal) o.getLeg2Quantity()))
				.put("commodityBase", ExistenceChecker.isSet((String) o.getCommodityBase()))
				.put("commodityDetails", ExistenceChecker.isSet((String) o.getCommodityDetails()))
				.put("interconnectionPoint", ExistenceChecker.isSet((String) o.getInterconnectionPoint()))
				.put("loadType", ExistenceChecker.isSet((String) o.getLoadType()))
				.put("fixedPriceUnit", ExistenceChecker.isSet((String) o.getFixedPriceUnit()))
				.put("exercisePaymentDateUnadjusted", ExistenceChecker.isSet((Date) o.getExercisePaymentDateUnadjusted()))
				.put("leg1PaymentDatesUnadjusted", ExistenceChecker.isSet((Date) o.getLeg1PaymentDatesUnadjusted()))
				.put("leg2PaymentDateUnadjusted", ExistenceChecker.isSet((Date) o.getLeg2PaymentDateUnadjusted()))
				.put("settlementDateUnadjusted", ExistenceChecker.isSet((Date) o.getSettlementDateUnadjusted()))
				.put("deliveryLocation", ExistenceChecker.isSet((String) o.getDeliveryLocation()))
				.put("leg2QuantityUnit", ExistenceChecker.isSet((String) o.getLeg2QuantityUnit()))
				.put("leg1CommodityUnderlyerDetails", ExistenceChecker.isSet((String) o.getLeg1CommodityUnderlyerDetails()))
				.put("leg2CommodityRateSourcePage", ExistenceChecker.isSet((String) o.getLeg2CommodityRateSourcePage()))
				.put("valueDate", ExistenceChecker.isSet((Date) o.getValueDate()))
				.put("gtrQuantityUnit", ExistenceChecker.isSet((String) o.getGtrQuantityUnit()))
				.put("attachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getAttachmentPoint()))
				.put("exhaustionPoint", ExistenceChecker.isSet((BigDecimal) o.getExhaustionPoint()))
				.put("mthToDefault", ExistenceChecker.isSet((BigDecimal) o.getMthToDefault()))
				.put("nthToDefault", ExistenceChecker.isSet((BigDecimal) o.getNthToDefault()))
				.put("seniority", ExistenceChecker.isSet((String) o.getSeniority()))
				.put("series", ExistenceChecker.isSet((BigDecimal) o.getSeries()))
				.put("crversion", ExistenceChecker.isSet((BigDecimal) o.getCrversion()))
				.put("tranche", ExistenceChecker.isSet((String) o.getTranche()))
				.put("indexFactor", ExistenceChecker.isSet((BigDecimal) o.getIndexFactor()))
				.put("referenceObligation", ExistenceChecker.isSet((String) o.getReferenceObligation()))
				.put("referenceObligationIdType", ExistenceChecker.isSet((String) o.getReferenceObligationIdType()))
				.put("underlyingFixedRatePayerBuyer", ExistenceChecker.isSet((String) o.getUnderlyingFixedRatePayerBuyer()))
				.put("underlyingFloatRatePayerSeller", ExistenceChecker.isSet((String) o.getUnderlyingFloatRatePayerSeller()))
				.put("underlyingAssetExchangeId", ExistenceChecker.isSet((String) o.getUnderlyingAssetExchangeId()))
				.put("underlyingAssetNumberOfUnits", ExistenceChecker.isSet((BigDecimal) o.getUnderlyingAssetNumberOfUnits()))
				.put("optionalEarlyTerminationType", ExistenceChecker.isSet((String) o.getOptionalEarlyTerminationType()))
				.put("optionalEarlyTerminationElectingPartyValue", ExistenceChecker.isSet((String) o.getOptionalEarlyTerminationElectingPartyValue()))
				.put("optionalEarlyTerminationIndicator", ExistenceChecker.isSet((Boolean) o.getOptionalEarlyTerminationIndicator()))
				.put("underlyingAssetFloatingAmountPayer", ExistenceChecker.isSet((String) o.getUnderlyingAssetFloatingAmountPayer()))
				.put("underlyingAssetFloatingAmountReceiver", ExistenceChecker.isSet((String) o.getUnderlyingAssetFloatingAmountReceiver()))
				.put("floatingRateOption", ExistenceChecker.isSet((String) o.getFloatingRateOption()))
				.put("underlyingAssetFloatingLegSpread", ExistenceChecker.isSet((BigDecimal) o.getUnderlyingAssetFloatingLegSpread()))
				.put("leg2DesignatedMaturityPeriod", ExistenceChecker.isSet((String) o.getLeg2DesignatedMaturityPeriod()))
				.put("leg2DesignatedMaturityPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getLeg2DesignatedMaturityPeriodMultiplier()))
				.put("underlyingAssetEquityAmountPayer", ExistenceChecker.isSet((String) o.getUnderlyingAssetEquityAmountPayer()))
				.put("underlyingAssetEquityAmountReceiver", ExistenceChecker.isSet((String) o.getUnderlyingAssetEquityAmountReceiver()))
				.put("underlyingAssetInitialPriceCurrency", ExistenceChecker.isSet((String) o.getUnderlyingAssetInitialPriceCurrency()))
				.put("leg1ValuationDates", ExistenceChecker.isSet((Date) o.getLeg1ValuationDates()))
				.put("leg1TypeOfReturn", ExistenceChecker.isSet((String) o.getLeg1TypeOfReturn()))
				.put("observationStartDate", ExistenceChecker.isSet((Date) o.getObservationStartDate()))
				.put("varianceAmount", ExistenceChecker.isSet((BigDecimal) o.getVarianceAmount()))
				.put("volatilityStrikePrice", ExistenceChecker.isSet((BigDecimal) o.getVolatilityStrikePrice()))
				.put("varianceStrikePrice", ExistenceChecker.isSet((BigDecimal) o.getVarianceStrikePrice()))
				.put("varianceCapFactor", ExistenceChecker.isSet((BigDecimal) o.getVarianceCapFactor()))
				.put("referenceCurrency", ExistenceChecker.isSet((String) o.getReferenceCurrency()))
				.put("specialDividendsIndicator", ExistenceChecker.isSet((String) o.getSpecialDividendsIndicator()))
				.put("materialNoncashDividendIndicator", ExistenceChecker.isSet((String) o.getMaterialNoncashDividendIndicator()))
				.put("numberOfSharesUnits", ExistenceChecker.isSet((BigDecimal) o.getNumberOfSharesUnits()))
				.put("dividendAmountPayer", ExistenceChecker.isSet((String) o.getDividendAmountPayer()))
				.put("dividendAmountReceiver", ExistenceChecker.isSet((String) o.getDividendAmountReceiver()))
				.put("fixedAmountPayer", ExistenceChecker.isSet((String) o.getFixedAmountPayer()))
				.put("fixedAmountReceiver", ExistenceChecker.isSet((String) o.getFixedAmountReceiver()))
				.put("knockInEvent", ExistenceChecker.isSet((String) o.getKnockInEvent()))
				.put("knockOutEvent", ExistenceChecker.isSet((String) o.getKnockOutEvent()))
				.put("knockInPrice", ExistenceChecker.isSet((BigDecimal) o.getKnockInPrice()))
				.put("knockOutPrice", ExistenceChecker.isSet((BigDecimal) o.getKnockOutPrice()))
				.put("barrierType", ExistenceChecker.isSet((String) o.getBarrierType()))
				.put("earliestExecutionTime", ExistenceChecker.isSet((LocalTime) o.getEarliestExecutionTime()))
				.put("exchangeRate", ExistenceChecker.isSet((BigDecimal) o.getExchangeRate()))
				.put("exchangeRateBasisCurrency1", ExistenceChecker.isSet((String) o.getExchangeRateBasisCurrency1()))
				.put("exchangeRateBasisCurrency2", ExistenceChecker.isSet((String) o.getExchangeRateBasisCurrency2()))
				.put("executionPeriodStartDate", ExistenceChecker.isSet((Date) o.getExecutionPeriodStartDate()))
				.put("payoutStyle", ExistenceChecker.isSet((String) o.getPayoutStyle()))
				.put("rateQuoteBasis1", ExistenceChecker.isSet((String) o.getRateQuoteBasis1()))
				.put("settlementFixingDate", ExistenceChecker.isSet((Date) o.getSettlementFixingDate()))
				.put("swapLinkId", ExistenceChecker.isSet((String) o.getSwapLinkId()))
				.put("triggerCondition", ExistenceChecker.isSet((String) o.getTriggerCondition()))
				.put("triggerCondition2", ExistenceChecker.isSet((String) o.getTriggerCondition2()))
				.put("triggerRate", ExistenceChecker.isSet((BigDecimal) o.getTriggerRate()))
				.put("triggerRate2", ExistenceChecker.isSet((BigDecimal) o.getTriggerRate2()))
				.put("rateQuoteBasis2", ExistenceChecker.isSet((String) o.getRateQuoteBasis2()))
				.put("forwardExchangeRate", ExistenceChecker.isSet((BigDecimal) o.getForwardExchangeRate()))
				.put("barrierType2", ExistenceChecker.isSet((String) o.getBarrierType2()))
				.put("cancelationOptionBuyer", ExistenceChecker.isSet((String) o.getCancelationOptionBuyer()))
				.put("cancelationOptionCommencementDate", ExistenceChecker.isSet((Date) o.getCancelationOptionCommencementDate()))
				.put("cancelationOptionExerciseStyleType", ExistenceChecker.isSet((String) o.getCancelationOptionExerciseStyleType()))
				.put("cancelationOptionExpirationDate", ExistenceChecker.isSet((Date) o.getCancelationOptionExpirationDate()))
				.put("cancelationOptionInitialFeeCurrency", ExistenceChecker.isSet((String) o.getCancelationOptionInitialFeeCurrency()))
				.put("cancelationOptionInitialFeePayer", ExistenceChecker.isSet((String) o.getCancelationOptionInitialFeePayer()))
				.put("cancelationOptionPremiumAmount", ExistenceChecker.isSet((BigDecimal) o.getCancelationOptionPremiumAmount()))
				.put("cancelationOptionSeller", ExistenceChecker.isSet((String) o.getCancelationOptionSeller()))
				.put("capRateInitial", ExistenceChecker.isSet((BigDecimal) o.getCapRateInitial()))
				.put("couponType", ExistenceChecker.isSet((String) o.getCouponType()))
				.put("finalPrincipalExchangeIndicatorAtTermination", ExistenceChecker.isSet((Boolean) o.getFinalPrincipalExchangeIndicatorAtTermination()))
				.put("floorRateInitial", ExistenceChecker.isSet((BigDecimal) o.getFloorRateInitial()))
				.put("fraDiscountingType", ExistenceChecker.isSet((String) o.getFraDiscountingType()))
				.put("inflationIndexInitialLevel", ExistenceChecker.isSet((BigDecimal) o.getInflationIndexInitialLevel()))
				.put("inflationIndexMainPublication", ExistenceChecker.isSet((String) o.getInflationIndexMainPublication()))
				.put("inflationInterpolationMethod", ExistenceChecker.isSet((String) o.getInflationInterpolationMethod()))
				.put("inflationLagDayType", ExistenceChecker.isSet((String) o.getInflationLagDayType()))
				.put("inflationLagPeriod", ExistenceChecker.isSet((String) o.getInflationLagPeriod()))
				.put("inflationRateSourceName", ExistenceChecker.isSet((String) o.getInflationRateSourceName()))
				.put("initialPrincipalExchangeIndicator", ExistenceChecker.isSet((Boolean) o.getInitialPrincipalExchangeIndicator()))
				.put("intermediatePrincipalExchangeIndicator", ExistenceChecker.isSet((Boolean) o.getIntermediatePrincipalExchangeIndicator()))
				.put("leg1FloatingRateIndex", ExistenceChecker.isSet((String) o.getLeg1FloatingRateIndex()))
				.put("leg1FloatingRateInitialSpread", ExistenceChecker.isSet((BigDecimal) o.getLeg1FloatingRateInitialSpread()))
				.put("leg1FloatingRateMultiplierInitialValue", ExistenceChecker.isSet((BigDecimal) o.getLeg1FloatingRateMultiplierInitialValue()))
				.put("leg1FloatingRateTenorPeriod", ExistenceChecker.isSet((String) o.getLeg1FloatingRateTenorPeriod()))
				.put("leg1FloatingRateTenorPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getLeg1FloatingRateTenorPeriodMultiplier()))
				.put("leg1KnownAmount", ExistenceChecker.isSet((BigDecimal) o.getLeg1KnownAmount()))
				.put("leg1KnownAmountCurrency", ExistenceChecker.isSet((String) o.getLeg1KnownAmountCurrency()))
				.put("leg1ReferenceCurrency", ExistenceChecker.isSet((String) o.getLeg1ReferenceCurrency()))
				.put("leg2FloatingRateIndex", ExistenceChecker.isSet((String) o.getLeg2FloatingRateIndex()))
				.put("leg2FloatingRateInitialSpread", ExistenceChecker.isSet((BigDecimal) o.getLeg2FloatingRateInitialSpread()))
				.put("leg2FloatingRateMultiplierInitialValue", ExistenceChecker.isSet((BigDecimal) o.getLeg2FloatingRateMultiplierInitialValue()))
				.put("leg2FloatingRateTenorPeriod", ExistenceChecker.isSet((String) o.getLeg2FloatingRateTenorPeriod()))
				.put("leg2FloatingRateTenorPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getLeg2FloatingRateTenorPeriodMultiplier()))
				.put("leg2KnownAmount", ExistenceChecker.isSet((BigDecimal) o.getLeg2KnownAmount()))
				.put("leg2KnownAmountCurrency", ExistenceChecker.isSet((String) o.getLeg2KnownAmountCurrency()))
				.put("leg2ReferenceCurrency", ExistenceChecker.isSet((String) o.getLeg2ReferenceCurrency()))
				.put("mandatoryEarlyTerminationDate", ExistenceChecker.isSet((Date) o.getMandatoryEarlyTerminationDate()))
				.put("mandatoryEarlyTerminationDateTenorPeriod", ExistenceChecker.isSet((String) o.getMandatoryEarlyTerminationDateTenorPeriod()))
				.put("mandatoryEarlyTerminationDateTenorPeriodMultiplier", ExistenceChecker.isSet((String) o.getMandatoryEarlyTerminationDateTenorPeriodMultiplier()))
				.put("notionalUnits", ExistenceChecker.isSet((BigDecimal) o.getNotionalUnits()))
				.put("optionalEarlyTerminationCommencementDate", ExistenceChecker.isSet((Date) o.getOptionalEarlyTerminationCommencementDate()))
				.put("optionalEarlyTerminationExerciseStyle", ExistenceChecker.isSet((String) o.getOptionalEarlyTerminationExerciseStyle()))
				.put("optionalEarlyTerminationExpirationDate", ExistenceChecker.isSet((Date) o.getOptionalEarlyTerminationExpirationDate()))
				.put("premiumReceiver", ExistenceChecker.isSet((String) o.getPremiumReceiver()))
				.put("underlyingCouponRate", ExistenceChecker.isSet((BigDecimal) o.getUnderlyingCouponRate()))
				.put("underlyingMaturityDate", ExistenceChecker.isSet((Date) o.getUnderlyingMaturityDate()))
				.put("underlyingProductId", ExistenceChecker.isSet((String) o.getUnderlyingProductId()))
				.put("inflationLagPeriodMultiplier", ExistenceChecker.isSet((String) o.getInflationLagPeriodMultiplier()))
				.put("leg1FixedRateNotation", ExistenceChecker.isSet((String) o.getLeg1FixedRateNotation()))
				.put("leg2FixedRateNotation", ExistenceChecker.isSet((String) o.getLeg2FixedRateNotation()))
				.put("swaptionStraddleIndicator", ExistenceChecker.isSet((String) o.getSwaptionStraddleIndicator()))
				.put("singlePartyEarlyTerminationBuyer", ExistenceChecker.isSet((String) o.getSinglePartyEarlyTerminationBuyer()))
				.put("leg1EffectiveDate", ExistenceChecker.isSet((Date) o.getLeg1EffectiveDate()))
				.put("action", ExistenceChecker.isSet((String) o.getAction()))
				.put("clearingStatus", ExistenceChecker.isSet((String) o.getClearingStatus()))
				.put("effectiveDate1", ExistenceChecker.isSet((Date) o.getEffectiveDate1()))
				.put("executionVenueType", ExistenceChecker.isSet((String) o.getExecutionVenueType()))
				.put("nonStandardTradeIndicator", ExistenceChecker.isSet((Boolean) o.getNonStandardTradeIndicator()))
				.put("notionalAmount1", ExistenceChecker.isSet((BigDecimal) o.getNotionalAmount1()))
				.put("notionalCurrency1", ExistenceChecker.isSet((String) o.getNotionalCurrency1()))
				.put("price1Price", ExistenceChecker.isSet((BigDecimal) o.getPrice1Price()))
				.put("price1Type", ExistenceChecker.isSet((String) o.getPrice1Type()))
				.put("price1Units", ExistenceChecker.isSet((String) o.getPrice1Units()))
				.put("scheduledTerminationDate1", ExistenceChecker.isSet((Date) o.getScheduledTerminationDate1()))
				.put("tradeDate", ExistenceChecker.isSet((Date) o.getTradeDate()))
				.put("tradeParty1CollateralizationType", ExistenceChecker.isSet((String) o.getTradeParty1CollateralizationType()))
				.put("tradeParty1EventId", ExistenceChecker.isSet((String) o.getTradeParty1EventId()))
				.put("tradeParty2CollateralizationType", ExistenceChecker.isSet((String) o.getTradeParty2CollateralizationType()))
				.put("tradeParty2EventId", ExistenceChecker.isSet((String) o.getTradeParty2EventId()))
				.put("embeddedOptionOnSwap", ExistenceChecker.isSet((String) o.getEmbeddedOptionOnSwap()))
				.put("expirationDate", ExistenceChecker.isSet((Date) o.getExpirationDate()))
				.put("notionalAmount2", ExistenceChecker.isSet((BigDecimal) o.getNotionalAmount2()))
				.put("notionalCurrency2", ExistenceChecker.isSet((String) o.getNotionalCurrency2()))
				.put("premiumAmount", ExistenceChecker.isSet((BigDecimal) o.getPremiumAmount()))
				.put("premiumCurrency", ExistenceChecker.isSet((String) o.getPremiumCurrency()))
				.put("version", ExistenceChecker.isSet((String) o.getVersion()))
				.put("comment1", ExistenceChecker.isSet((String) o.getComment1()))
				.put("optionStyle", ExistenceChecker.isSet((String) o.getOptionStyle()))
				.put("optionType", ExistenceChecker.isSet((String) o.getOptionType()))
				.put("settlementCurrency1", ExistenceChecker.isSet((String) o.getSettlementCurrency1()))
				.put("commencementDate", ExistenceChecker.isSet((Date) o.getCommencementDate()))
				.put("dayCountFraction1", ExistenceChecker.isSet((String) o.getDayCountFraction1()))
				.put("leg2DayCountFraction", ExistenceChecker.isSet((String) o.getLeg2DayCountFraction()))
				.put("leg2EffectiveDate", ExistenceChecker.isSet((Date) o.getLeg2EffectiveDate()))
				.put("leg2ResetFrequencyPeriod", ExistenceChecker.isSet((String) o.getLeg2ResetFrequencyPeriod()))
				.put("leg2ResetFrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getLeg2ResetFrequencyPeriodMultiplier()))
				.put("leg2SettlementCurrency", ExistenceChecker.isSet((String) o.getLeg2SettlementCurrency()))
				.put("leg2ScheduledTerminationDate", ExistenceChecker.isSet((Date) o.getLeg2ScheduledTerminationDate()))
				.put("numberOfOptions", ExistenceChecker.isSet((BigDecimal) o.getNumberOfOptions()))
				.put("optionEntitlement", ExistenceChecker.isSet((BigDecimal) o.getOptionEntitlement()))
				.put("originalExecutionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getOriginalExecutionTimestamp()))
				.put("payment1Date", ExistenceChecker.isSet((Date) o.getPayment1Date()))
				.put("payment1FrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment1FrequencyPeriod()))
				.put("payment1FrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment1FrequencyPeriodMultiplier()))
				.put("payment2Date", ExistenceChecker.isSet((Date) o.getPayment2Date()))
				.put("payment2FrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment2FrequencyPeriod()))
				.put("payment2FrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment2FrequencyPeriodMultiplier()))
				.put("resetFrequencyPeriod1", ExistenceChecker.isSet((String) o.getResetFrequencyPeriod1()))
				.put("resetFrequencyPeriodMultiplier1", ExistenceChecker.isSet((BigDecimal) o.getResetFrequencyPeriodMultiplier1()))
				.put("settlementDate", ExistenceChecker.isSet((Date) o.getSettlementDate()))
				.put("strikePrice", ExistenceChecker.isSet((BigDecimal) o.getStrikePrice()))
				.put("strikePriceUnits", ExistenceChecker.isSet((String) o.getStrikePriceUnits()))
				.put("asOfDateTime", ExistenceChecker.isSet((ZonedDateTime) o.getAsOfDateTime()))
				.put("clearingVenueId", ExistenceChecker.isSet((String) o.getClearingVenueId()))
				.put("clearingVenueIdType", ExistenceChecker.isSet((String) o.getClearingVenueIdType()))
				.put("compressedTradeIndicator", ExistenceChecker.isSet((String) o.getCompressedTradeIndicator()))
				.put("confirmationMethod", ExistenceChecker.isSet((String) o.getConfirmationMethod()))
				.put("confirmationPlatformId", ExistenceChecker.isSet((String) o.getConfirmationPlatformId()))
				.put("confirmationPlatformTradeId", ExistenceChecker.isSet((String) o.getConfirmationPlatformTradeId()))
				.put("executionVenueId", ExistenceChecker.isSet((String) o.getExecutionVenueId()))
				.put("executionVenueIdType", ExistenceChecker.isSet((String) o.getExecutionVenueIdType()))
				.put("postTradeEffectiveDate", ExistenceChecker.isSet((Date) o.getPostTradeEffectiveDate()))
				.put("priorUsiId", ExistenceChecker.isSet((String) o.getPriorUsiId()))
				.put("priorUsiIdPrefix", ExistenceChecker.isSet((String) o.getPriorUsiIdPrefix()))
				.put("priorUtiId", ExistenceChecker.isSet((String) o.getPriorUtiId()))
				.put("priorUtiIdPrefix", ExistenceChecker.isSet((String) o.getPriorUtiIdPrefix()))
				.put("tradeParty1BranchLocation", ExistenceChecker.isSet((String) o.getTradeParty1BranchLocation()))
				.put("tradeParty1ClearingBrokerId", ExistenceChecker.isSet((String) o.getTradeParty1ClearingBrokerId()))
				.put("tradeParty1ClearingBrokerIdType", ExistenceChecker.isSet((String) o.getTradeParty1ClearingBrokerIdType()))
				.put("tradeParty1DeskLocation", ExistenceChecker.isSet((String) o.getTradeParty1DeskLocation()))
				.put("tradeParty1Domicile", ExistenceChecker.isSet((String) o.getTradeParty1Domicile()))
				.put("tradeParty1IndustrialSectorType", ExistenceChecker.isSet((String) o.getTradeParty1IndustrialSectorType()))
				.put("tradeParty2BranchLocation", ExistenceChecker.isSet((String) o.getTradeParty2BranchLocation()))
				.put("tradeParty2DeskLocation", ExistenceChecker.isSet((String) o.getTradeParty2DeskLocation()))
				.put("tradeParty2Domicile", ExistenceChecker.isSet((String) o.getTradeParty2Domicile()))
				.put("tradeParty2IndustrialSectorType", ExistenceChecker.isSet((String) o.getTradeParty2IndustrialSectorType()))
				.put("sellerPayer2", ExistenceChecker.isSet((String) o.getSellerPayer2()))
				.put("buyerPayer1", ExistenceChecker.isSet((String) o.getBuyerPayer1()))
				.put("tradeParty1HkCounterpartyOrigin", ExistenceChecker.isSet((String) o.getTradeParty1HkCounterpartyOrigin()))
				.put("leg2SettlementDate", ExistenceChecker.isSet((Date) o.getLeg2SettlementDate()))
				.put("leg1FixedRateInitial", ExistenceChecker.isSet((BigDecimal) o.getLeg1FixedRateInitial()))
				.put("leg2FixedRateInitial", ExistenceChecker.isSet((BigDecimal) o.getLeg2FixedRateInitial()))
				.put("payment1Amount", ExistenceChecker.isSet((BigDecimal) o.getPayment1Amount()))
				.put("payment1Currency", ExistenceChecker.isSet((String) o.getPayment1Currency()))
				.put("payment1Payer", ExistenceChecker.isSet((String) o.getPayment1Payer()))
				.put("payment1Receiver", ExistenceChecker.isSet((String) o.getPayment1Receiver()))
				.put("payment2Payer", ExistenceChecker.isSet((String) o.getPayment2Payer()))
				.put("postTradeTransactionDate", ExistenceChecker.isSet((Date) o.getPostTradeTransactionDate()))
				.put("secondaryAssetClass", ExistenceChecker.isSet((String) o.getSecondaryAssetClass()))
				.put("settlementType", ExistenceChecker.isSet((String) o.getSettlementType()))
				.put("tradeParty1Name", ExistenceChecker.isSet((String) o.getTradeParty1Name()))
				.put("tradeParty2Name", ExistenceChecker.isSet((String) o.getTradeParty2Name()))
				.put("ccpValuationAmount", ExistenceChecker.isSet((BigDecimal) o.getCcpValuationAmount()))
				.put("ccpValuationCurrency", ExistenceChecker.isSet((String) o.getCcpValuationCurrency()))
				.put("ccpValuationDatetime", ExistenceChecker.isSet((ZonedDateTime) o.getCcpValuationDatetime()))
				.put("ccpValuationType", ExistenceChecker.isSet((String) o.getCcpValuationType()))
				.put("tradeParty1ValuationAmount", ExistenceChecker.isSet((BigDecimal) o.getTradeParty1ValuationAmount()))
				.put("tradeParty1ValuationCurrency", ExistenceChecker.isSet((String) o.getTradeParty1ValuationCurrency()))
				.put("tradeParty1ValuationDatetime", ExistenceChecker.isSet((ZonedDateTime) o.getTradeParty1ValuationDatetime()))
				.put("tradeParty1ValuationType", ExistenceChecker.isSet((String) o.getTradeParty1ValuationType()))
				.put("tradeParty2ValuationAmount", ExistenceChecker.isSet((BigDecimal) o.getTradeParty2ValuationAmount()))
				.put("tradeParty2ValuationCurrency", ExistenceChecker.isSet((String) o.getTradeParty2ValuationCurrency()))
				.put("tradeParty2ValuationDatetime", ExistenceChecker.isSet((ZonedDateTime) o.getTradeParty2ValuationDatetime()))
				.put("tradeParty2ValuationType", ExistenceChecker.isSet((String) o.getTradeParty2ValuationType()))
				.put("executionType", ExistenceChecker.isSet((String) o.getExecutionType()))
				.put("strikePriceCurrency", ExistenceChecker.isSet((String) o.getStrikePriceCurrency()))
				.put("payment2Amount", ExistenceChecker.isSet((BigDecimal) o.getPayment2Amount()))
				.put("tradeParty2HkCounterpartyOrigin", ExistenceChecker.isSet((String) o.getTradeParty2HkCounterpartyOrigin()))
				.put("tradeParty1CountryOfTheOtherCounterparty", ExistenceChecker.isSet((String) o.getTradeParty1CountryOfTheOtherCounterparty()))
				.put("tradeParty2CountryOfTheOtherCounterparty", ExistenceChecker.isSet((String) o.getTradeParty2CountryOfTheOtherCounterparty()))
				.put("tradeParty1BrokerId", ExistenceChecker.isSet((String) o.getTradeParty1BrokerId()))
				.put("tradeParty2BrokerId", ExistenceChecker.isSet((String) o.getTradeParty2BrokerId()))
				.put("tradeParty1BeneficiaryIdType", ExistenceChecker.isSet((String) o.getTradeParty1BeneficiaryIdType()))
				.put("tradeParty1BeneficiaryId", ExistenceChecker.isSet((String) o.getTradeParty1BeneficiaryId()))
				.put("tradeParty2BeneficiaryIdType", ExistenceChecker.isSet((String) o.getTradeParty2BeneficiaryIdType()))
				.put("tradeParty2BeneficiaryId", ExistenceChecker.isSet((String) o.getTradeParty2BeneficiaryId()))
				.put("tradeParty1CounterpartySide", ExistenceChecker.isSet((String) o.getTradeParty1CounterpartySide()))
				.put("tradeParty2CounterpartySide", ExistenceChecker.isSet((String) o.getTradeParty2CounterpartySide()))
				.put("tradeParty1CollateralPortfolioCode", ExistenceChecker.isSet((String) o.getTradeParty1CollateralPortfolioCode()))
				.put("tradeParty2CollateralPortfolioCode", ExistenceChecker.isSet((String) o.getTradeParty2CollateralPortfolioCode()))
				.put("contractType", ExistenceChecker.isSet((String) o.getContractType()))
				.put("euUnderlyingAssetIdType", ExistenceChecker.isSet((String) o.getEuUnderlyingAssetIdType()))
				.put("productClassification", ExistenceChecker.isSet((String) o.getProductClassification()))
				.put("complexTradeComponentId", ExistenceChecker.isSet((String) o.getComplexTradeComponentId()))
				.put("priceMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPriceMultiplier()))
				.put("quantity", ExistenceChecker.isSet((BigDecimal) o.getQuantity()))
				.put("masterAgreementType", ExistenceChecker.isSet((String) o.getMasterAgreementType()))
				.put("masterAgreementVersion", ExistenceChecker.isSet((String) o.getMasterAgreementVersion()))
				.put("confirmationDatetime", ExistenceChecker.isSet((ZonedDateTime) o.getConfirmationDatetime()))
				.put("clearingDatetime", ExistenceChecker.isSet((ZonedDateTime) o.getClearingDatetime()))
				.put("maturityDateOfTheUnderlying", ExistenceChecker.isSet((Date) o.getMaturityDateOfTheUnderlying()))
				.put("level", ExistenceChecker.isSet((String) o.getLevel()))
				.put("productClassificationType", ExistenceChecker.isSet((String) o.getProductClassificationType()))
				.put("productIdentificationType", ExistenceChecker.isSet((String) o.getProductIdentificationType()))
				.put("productIdentification", ExistenceChecker.isSet((String) o.getProductIdentification()))
				.put("euUnderlyingAssetId", ExistenceChecker.isSet((String) o.getEuUnderlyingAssetId()))
				.put("reportTrackingNumber", ExistenceChecker.isSet((String) o.getReportTrackingNumber()))
				.put("tradeParty1BrokerIdType", ExistenceChecker.isSet((String) o.getTradeParty1BrokerIdType()))
				.put("tradeParty2BrokerIdType", ExistenceChecker.isSet((String) o.getTradeParty2BrokerIdType()))
				.put("tradeParty2ClearingBrokerIdType", ExistenceChecker.isSet((String) o.getTradeParty2ClearingBrokerIdType()))
				.put("tradeParty2ClearingBrokerId", ExistenceChecker.isSet((String) o.getTradeParty2ClearingBrokerId()))
				.put("tradeParty1ClearingThreshold", ExistenceChecker.isSet((Boolean) o.getTradeParty1ClearingThreshold()))
				.put("tradeParty2ClearingThreshold", ExistenceChecker.isSet((Boolean) o.getTradeParty2ClearingThreshold()))
				.put("tradeParty1CorporateSectorType", ExistenceChecker.isSet((String) o.getTradeParty1CorporateSectorType()))
				.put("tradeParty2CorporateSectorType", ExistenceChecker.isSet((String) o.getTradeParty2CorporateSectorType()))
				.put("tradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator", ExistenceChecker.isSet((String) o.getTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator()))
				.put("tradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator", ExistenceChecker.isSet((String) o.getTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator()))
				.put("intragroupIndicator", ExistenceChecker.isSet((Boolean) o.getIntragroupIndicator()))
				.put("tradeParty1TradingCapacity1", ExistenceChecker.isSet((String) o.getTradeParty1TradingCapacity1()))
				.put("tradeParty2TradingCapacity1", ExistenceChecker.isSet((String) o.getTradeParty2TradingCapacity1()))
				.put("currencyOfPrice", ExistenceChecker.isSet((String) o.getCurrencyOfPrice()))
				.put("tradeParty1CollateralPortfolio", ExistenceChecker.isSet((String) o.getTradeParty1CollateralPortfolio()))
				.put("tradeParty2CollateralPortfolio", ExistenceChecker.isSet((String) o.getTradeParty2CollateralPortfolio()))
				.put("executionVenueMicCode", ExistenceChecker.isSet((String) o.getExecutionVenueMicCode()))
				.put("payment2Currency", ExistenceChecker.isSet((String) o.getPayment2Currency()))
				.put("expirationDateTimeBusinessCenter", ExistenceChecker.isSet((String) o.getExpirationDateTimeBusinessCenter()))
				.put("expirationTime", ExistenceChecker.isSet((LocalTime) o.getExpirationTime()))
				.put("expirationTimeType", ExistenceChecker.isSet((String) o.getExpirationTimeType()))
				.put("tradeParty1TraderLocation", ExistenceChecker.isSet((String) o.getTradeParty1TraderLocation()))
				.put("tradeParty2TraderLocation", ExistenceChecker.isSet((String) o.getTradeParty2TraderLocation()))
				.put("payment3ResetFrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment3ResetFrequencyPeriodMultiplier()))
				.put("payment3ResetFrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment3ResetFrequencyPeriod()))
				.put("payment4ResetFrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment4ResetFrequencyPeriodMultiplier()))
				.put("payment4ResetFrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment4ResetFrequencyPeriod()))
				.put("payment5ResetFrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment5ResetFrequencyPeriodMultiplier()))
				.put("payment5ResetFrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment5ResetFrequencyPeriod()))
				.put("payment1Type", ExistenceChecker.isSet((String) o.getPayment1Type()))
				.put("payment1Reference", ExistenceChecker.isSet((String) o.getPayment1Reference()))
				.put("payment2Type", ExistenceChecker.isSet((String) o.getPayment2Type()))
				.put("payment2Reference", ExistenceChecker.isSet((String) o.getPayment2Reference()))
				.put("payment3Payer", ExistenceChecker.isSet((String) o.getPayment3Payer()))
				.put("payment3Reference", ExistenceChecker.isSet((String) o.getPayment3Reference()))
				.put("payment3FrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment3FrequencyPeriod()))
				.put("payment3FrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment3FrequencyPeriodMultiplier()))
				.put("payment3Date", ExistenceChecker.isSet((Date) o.getPayment3Date()))
				.put("payment4Reference", ExistenceChecker.isSet((String) o.getPayment4Reference()))
				.put("payment4Payer", ExistenceChecker.isSet((String) o.getPayment4Payer()))
				.put("payment4FrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment4FrequencyPeriod()))
				.put("payment4FrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment4FrequencyPeriodMultiplier()))
				.put("payment4Date", ExistenceChecker.isSet((Date) o.getPayment4Date()))
				.put("payment5Reference", ExistenceChecker.isSet((String) o.getPayment5Reference()))
				.put("payment5Payer", ExistenceChecker.isSet((String) o.getPayment5Payer()))
				.put("payment5FrequencyPeriod", ExistenceChecker.isSet((String) o.getPayment5FrequencyPeriod()))
				.put("payment5FrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getPayment5FrequencyPeriodMultiplier()))
				.put("payment5Date", ExistenceChecker.isSet((Date) o.getPayment5Date()))
				.put("payment3Type", ExistenceChecker.isSet((String) o.getPayment3Type()))
				.put("premiumPayer", ExistenceChecker.isSet((String) o.getPremiumPayer()))
				.put("premiumPaymentDateUnadjusted", ExistenceChecker.isSet((Date) o.getPremiumPaymentDateUnadjusted()))
				.put("tradeParty1NatureOfTheReportingCounterparty", ExistenceChecker.isSet((String) o.getTradeParty1NatureOfTheReportingCounterparty()))
				.put("tradeParty2NatureOfTheReportingCounterparty", ExistenceChecker.isSet((String) o.getTradeParty2NatureOfTheReportingCounterparty()))
				.put("reservedParticipantUse1", ExistenceChecker.isSet((String) o.getReservedParticipantUse1()))
				.put("reservedParticipantUse2", ExistenceChecker.isSet((String) o.getReservedParticipantUse2()))
				.put("reservedParticipantUse3", ExistenceChecker.isSet((String) o.getReservedParticipantUse3()))
				.put("reservedParticipantUse4", ExistenceChecker.isSet((String) o.getReservedParticipantUse4()))
				.put("reservedParticipantUse5", ExistenceChecker.isSet((String) o.getReservedParticipantUse5()))
				.put("leg1TerminationDate", ExistenceChecker.isSet((Date) o.getLeg1TerminationDate()))
				.put("allocationType", ExistenceChecker.isSet((String) o.getAllocationType()))
				.put("calculationBasis", ExistenceChecker.isSet((String) o.getCalculationBasis()))
				.put("clearingExceptionPartyId", ExistenceChecker.isSet((String) o.getClearingExceptionPartyId()))
				.put("clearingExceptionPartyIdType", ExistenceChecker.isSet((String) o.getClearingExceptionPartyIdType()))
				.put("clearingExceptionType", ExistenceChecker.isSet((String) o.getClearingExceptionType()))
				.put("clearingMemberClientAccountId", ExistenceChecker.isSet((String) o.getClearingMemberClientAccountId()))
				.put("clearingReceiptDatetime", ExistenceChecker.isSet((ZonedDateTime) o.getClearingReceiptDatetime()))
				.put("clearingSwapSdrLeiId", ExistenceChecker.isSet((String) o.getClearingSwapSdrLeiId()))
				.put("clearingSwapUtiId", ExistenceChecker.isSet((String) o.getClearingSwapUtiId()))
				.put("collateralReportingDate", ExistenceChecker.isSet((Date) o.getCollateralReportingDate()))
				.put("collateralValuationDatetime", ExistenceChecker.isSet((ZonedDateTime) o.getCollateralValuationDatetime()))
				.put("comment2", ExistenceChecker.isSet((String) o.getComment2()))
				.put("commodityStrikePriceUnit", ExistenceChecker.isSet((String) o.getCommodityStrikePriceUnit()))
				.put("executionAgentMaskingIndicator", ExistenceChecker.isSet((String) o.getExecutionAgentMaskingIndicator()))
				.put("feeInCurrency", ExistenceChecker.isSet((String) o.getFeeInCurrency()))
				.put("feeOutCurrency", ExistenceChecker.isSet((String) o.getFeeOutCurrency()))
				.put("floatingRatePaymentFrequencyLeg1Multiplier", ExistenceChecker.isSet((BigDecimal) o.getFloatingRatePaymentFrequencyLeg1Multiplier()))
				.put("floatingRatePaymentFrequencyLeg1TimePeriod", ExistenceChecker.isSet((String) o.getFloatingRatePaymentFrequencyLeg1TimePeriod()))
				.put("floatingRatePaymentFrequencyLeg2Multiplier", ExistenceChecker.isSet((BigDecimal) o.getFloatingRatePaymentFrequencyLeg2Multiplier()))
				.put("floatingRatePaymentFrequencyLeg2TimePeriod", ExistenceChecker.isSet((String) o.getFloatingRatePaymentFrequencyLeg2TimePeriod()))
				.put("frequencyOfPayment", ExistenceChecker.isSet((String) o.getFrequencyOfPayment()))
				.put("interaffiliate", ExistenceChecker.isSet((Boolean) o.getInteraffiliate()))
				.put("largeTradeIndicator", ExistenceChecker.isSet((Boolean) o.getLargeTradeIndicator()))
				.put("leg1EffectiveDateAdjusted", ExistenceChecker.isSet((Date) o.getLeg1EffectiveDateAdjusted()))
				.put("leg1FinalValuationDate", ExistenceChecker.isSet((Date) o.getLeg1FinalValuationDate()))
				.put("leg1SettlementPeriod", ExistenceChecker.isSet((String) o.getLeg1SettlementPeriod()))
				.put("leg2EffectiveDateAdjusted", ExistenceChecker.isSet((Date) o.getLeg2EffectiveDateAdjusted()))
				.put("leg2PaymentTermsFrequencyPeriod", ExistenceChecker.isSet((String) o.getLeg2PaymentTermsFrequencyPeriod()))
				.put("leg2PaymentTermsPaymentFrequencyPeriodMultiplier", ExistenceChecker.isSet((BigDecimal) o.getLeg2PaymentTermsPaymentFrequencyPeriodMultiplier()))
				.put("leg2SettlementType", ExistenceChecker.isSet((String) o.getLeg2SettlementType()))
				.put("leg2UnderlyingAssetId", ExistenceChecker.isSet((String) o.getLeg2UnderlyingAssetId()))
				.put("leg2UnderlyingAssetIdType", ExistenceChecker.isSet((String) o.getLeg2UnderlyingAssetIdType()))
				.put("leg2UnderlyingAssetName", ExistenceChecker.isSet((String) o.getLeg2UnderlyingAssetName()))
				.put("maturityDate", ExistenceChecker.isSet((Date) o.getMaturityDate()))
				.put("optionalEarlyTerminationDate", ExistenceChecker.isSet((String) o.getOptionalEarlyTerminationDate()))
				.put("optionCommodityCurrency", ExistenceChecker.isSet((String) o.getOptionCommodityCurrency()))
				.put("optionCommodityExchangeId", ExistenceChecker.isSet((String) o.getOptionCommodityExchangeId()))
				.put("optionCommodityInstrumentId", ExistenceChecker.isSet((String) o.getOptionCommodityInstrumentId()))
				.put("optionCommodityRateSource", ExistenceChecker.isSet((String) o.getOptionCommodityRateSource()))
				.put("optionCommodityRateSourcePage", ExistenceChecker.isSet((String) o.getOptionCommodityRateSourcePage()))
				.put("optionCommodityUnderlyerDetails", ExistenceChecker.isSet((String) o.getOptionCommodityUnderlyerDetails()))
				.put("optionCommodityUnderlyerId", ExistenceChecker.isSet((String) o.getOptionCommodityUnderlyerId()))
				.put("optionCommodityUnitOfMeasure", ExistenceChecker.isSet((String) o.getOptionCommodityUnitOfMeasure()))
				.put("optionSpecifiedPrice", ExistenceChecker.isSet((String) o.getOptionSpecifiedPrice()))
				.put("optionSpreadAmount", ExistenceChecker.isSet((BigDecimal) o.getOptionSpreadAmount()))
				.put("optionSpreadCurrency", ExistenceChecker.isSet((String) o.getOptionSpreadCurrency()))
				.put("optionSpreadSchedule", ExistenceChecker.isSet((String) o.getOptionSpreadSchedule()))
				.put("origin", ExistenceChecker.isSet((String) o.getOrigin()))
				.put("originalSwapSdrId", ExistenceChecker.isSet((String) o.getOriginalSwapSdrId()))
				.put("originalSwapSdrIdType", ExistenceChecker.isSet((String) o.getOriginalSwapSdrIdType()))
				.put("paymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getPaymentFrequencyPeriodLeg1()))
				.put("paymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getPaymentFrequencyPeriodLeg2()))
				.put("paymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((BigDecimal) o.getPaymentFrequencyPeriodMultiplierLeg1()))
				.put("paymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((BigDecimal) o.getPaymentFrequencyPeriodMultiplierLeg2()))
				.put("premiumPayerPrefix", ExistenceChecker.isSet((String) o.getPremiumPayerPrefix()))
				.put("price1Currency", ExistenceChecker.isSet((String) o.getPrice1Currency()))
				.put("price2Price", ExistenceChecker.isSet((BigDecimal) o.getPrice2Price()))
				.put("price2Type", ExistenceChecker.isSet((String) o.getPrice2Type()))
				.put("price2Units", ExistenceChecker.isSet((String) o.getPrice2Units()))
				.put("price3Price", ExistenceChecker.isSet((BigDecimal) o.getPrice3Price()))
				.put("price3Type", ExistenceChecker.isSet((String) o.getPrice3Type()))
				.put("price3Units", ExistenceChecker.isSet((String) o.getPrice3Units()))
				.put("price4Price", ExistenceChecker.isSet((BigDecimal) o.getPrice4Price()))
				.put("price4Type", ExistenceChecker.isSet((String) o.getPrice4Type()))
				.put("price4Units", ExistenceChecker.isSet((String) o.getPrice4Units()))
				.put("pricingContext", ExistenceChecker.isSet((String) o.getPricingContext()))
				.put("priorUsiType", ExistenceChecker.isSet((String) o.getPriorUsiType()))
				.put("priorUtiType", ExistenceChecker.isSet((String) o.getPriorUtiType()))
				.put("recoveryPrice", ExistenceChecker.isSet((BigDecimal) o.getRecoveryPrice()))
				.put("sendToDataCenterCode", ExistenceChecker.isSet((String) o.getSendToDataCenterCode()))
				.put("strikePriceType", ExistenceChecker.isSet((String) o.getStrikePriceType()))
				.put("subAssetClassForOtherCommodity", ExistenceChecker.isSet((String) o.getSubAssetClassForOtherCommodity()))
				.put("tradeParty1CftcFinancialEntityStatus", ExistenceChecker.isSet((String) o.getTradeParty1CftcFinancialEntityStatus()))
				.put("tradeParty1CollateralAmount", ExistenceChecker.isSet((BigDecimal) o.getTradeParty1CollateralAmount()))
				.put("tradeParty1CollateralCurrency", ExistenceChecker.isSet((String) o.getTradeParty1CollateralCurrency()))
				.put("tradeParty1MandatoryDelegatedReporting", ExistenceChecker.isSet((String) o.getTradeParty1MandatoryDelegatedReporting()))
				.put("tradeParty1Role", ExistenceChecker.isSet((String) o.getTradeParty1Role()))
				.put("tradeParty2CftcFinancialEntityStatus", ExistenceChecker.isSet((String) o.getTradeParty2CftcFinancialEntityStatus()))
				.put("tradeParty2CollateralAmount", ExistenceChecker.isSet((BigDecimal) o.getTradeParty2CollateralAmount()))
				.put("tradeParty2CollateralCurrency", ExistenceChecker.isSet((String) o.getTradeParty2CollateralCurrency()))
				.put("tradeParty2MandatoryDelegatedReporting", ExistenceChecker.isSet((String) o.getTradeParty2MandatoryDelegatedReporting()))
				.put("tradeParty2Role", ExistenceChecker.isSet((String) o.getTradeParty2Role()))
				.put("upfrontPayment", ExistenceChecker.isSet((BigDecimal) o.getUpfrontPayment()))
				.put("verificationMethod", ExistenceChecker.isSet((String) o.getVerificationMethod()))
				.put("responsibleDataSubmitterId", ExistenceChecker.isSet((String) o.getResponsibleDataSubmitterId()))
				.put("responsibleDataSubmitterIdType", ExistenceChecker.isSet((String) o.getResponsibleDataSubmitterIdType()))
				.put("originalSwapUsi", ExistenceChecker.isSet((String) o.getOriginalSwapUsi()))
				.put("originalSwapUti", ExistenceChecker.isSet((String) o.getOriginalSwapUti()))
				.put("cdeReceiverIdentifierLeg2", ExistenceChecker.isSet((String) o.getCdeReceiverIdentifierLeg2()))
				.put("counterparty1FederalEntityIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty1FederalEntityIndicator()))
				.put("counterparty2FederalEntityIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty2FederalEntityIndicator()))
				.put("customBasketIndicator", ExistenceChecker.isSet((Boolean) o.getCustomBasketIndicator()))
				.put("noaActionType", ExistenceChecker.isSet((String) o.getNoaActionType()))
				.put("eventType", ExistenceChecker.isSet((String) o.getEventType()))
				.put("amendmentIndicator", ExistenceChecker.isSet((Boolean) o.getAmendmentIndicator()))
				.put("eventIdentifier", ExistenceChecker.isSet((String) o.getEventIdentifier()))
				.put("cdeCallAmountLeg1", ExistenceChecker.isSet((BigDecimal) o.getCdeCallAmountLeg1()))
				.put("cdeCallAmountLeg2", ExistenceChecker.isSet((BigDecimal) o.getCdeCallAmountLeg2()))
				.put("cdeCallCurrencyLeg1", ExistenceChecker.isSet((String) o.getCdeCallCurrencyLeg1()))
				.put("cdeCallCurrencyLeg2", ExistenceChecker.isSet((String) o.getCdeCallCurrencyLeg2()))
				.put("cdePutAmountLeg1", ExistenceChecker.isSet((BigDecimal) o.getCdePutAmountLeg1()))
				.put("cdePutAmountLeg2", ExistenceChecker.isSet((BigDecimal) o.getCdePutAmountLeg2()))
				.put("cdePutCurrencyLeg1", ExistenceChecker.isSet((String) o.getCdePutCurrencyLeg1()))
				.put("cdePutCurrencyLeg2", ExistenceChecker.isSet((String) o.getCdePutCurrencyLeg2()))
				.put("leg2QuantityFrequency", ExistenceChecker.isSet((String) o.getLeg2QuantityFrequency()))
				.put("quantityFrequencyMultiplierLeg1", ExistenceChecker.isSet((BigDecimal) o.getQuantityFrequencyMultiplierLeg1()))
				.put("quantityFrequencyMultiplierLeg2", ExistenceChecker.isSet((BigDecimal) o.getQuantityFrequencyMultiplierLeg2()))
				.put("cdeQuantityUnitOfMeasureLeg1", ExistenceChecker.isSet((String) o.getCdeQuantityUnitOfMeasureLeg1()))
				.put("cdeQuantityUnitOfMeasureLeg2", ExistenceChecker.isSet((String) o.getCdeQuantityUnitOfMeasureLeg2()))
				.put("packageIndicator", ExistenceChecker.isSet((Boolean) o.getPackageIndicator()))
				.put("cdePackageIdentifier", ExistenceChecker.isSet((String) o.getCdePackageIdentifier()))
				.put("cdePackageTransactionPrice", ExistenceChecker.isSet((BigDecimal) o.getCdePackageTransactionPrice()))
				.put("cdePackageTransactionPriceCurrency", ExistenceChecker.isSet((String) o.getCdePackageTransactionPriceCurrency()))
				.put("cdePackageTransactionPriceNotation", ExistenceChecker.isSet((String) o.getCdePackageTransactionPriceNotation()))
				.put("cdePackageTransactionSpread", ExistenceChecker.isSet((BigDecimal) o.getCdePackageTransactionSpread()))
				.put("cdePackageTransactionSpreadCurrency", ExistenceChecker.isSet((String) o.getCdePackageTransactionSpreadCurrency()))
				.put("cdePackageTransactionSpreadNotation", ExistenceChecker.isSet((String) o.getCdePackageTransactionSpreadNotation()))
				.put("cdeFixedRateDayCountConventionLeg1", ExistenceChecker.isSet((String) o.getCdeFixedRateDayCountConventionLeg1()))
				.put("cdeFixedRateDayCountConventionLeg2", ExistenceChecker.isSet((String) o.getCdeFixedRateDayCountConventionLeg2()))
				.put("cdeFloatingRateDayCountConventionLeg1", ExistenceChecker.isSet((String) o.getCdeFloatingRateDayCountConventionLeg1()))
				.put("cdeFloatingRateDayCountConventionLeg2", ExistenceChecker.isSet((String) o.getCdeFloatingRateDayCountConventionLeg2()))
				.put("fixingDateLeg1", ExistenceChecker.isSet((Date) o.getFixingDateLeg1()))
				.put("fixingDateLeg2", ExistenceChecker.isSet((Date) o.getFixingDateLeg2()))
				.put("cdeFixedRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getCdeFixedRatePaymentFrequencyPeriodLeg1()))
				.put("cdeFixedRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getCdeFixedRatePaymentFrequencyPeriodLeg2()))
				.put("cdeFloatingRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getCdeFloatingRatePaymentFrequencyPeriodLeg1()))
				.put("cdeFloatingRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getCdeFloatingRatePaymentFrequencyPeriodLeg2()))
				.put("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((BigDecimal) o.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1()))
				.put("cdeFixedRatePaymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((BigDecimal) o.getCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2()))
				.put("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((BigDecimal) o.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1()))
				.put("cdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((BigDecimal) o.getCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2()))
				.put("postPricedSwapIndicator", ExistenceChecker.isSet((Boolean) o.getPostPricedSwapIndicator()))
				.put("cdePriceCurrency", ExistenceChecker.isSet((String) o.getCdePriceCurrency()))
				.put("cdePriceNotation", ExistenceChecker.isSet((String) o.getCdePriceNotation()))
				.put("cdeSpreadNotationLeg1", ExistenceChecker.isSet((String) o.getCdeSpreadNotationLeg1()))
				.put("cdeSpreadNotationLeg2", ExistenceChecker.isSet((String) o.getCdeSpreadNotationLeg2()))
				.put("cdeStrikePriceCurrency2", ExistenceChecker.isSet((String) o.getCdeStrikePriceCurrency2()))
				.put("cdeStrikePriceNotation", ExistenceChecker.isSet((String) o.getCdeStrikePriceNotation()))
				.put("cdeFirstExerciseDate", ExistenceChecker.isSet((Date) o.getCdeFirstExerciseDate()))
				.put("cdeFinalContractualSettlementDate", ExistenceChecker.isSet((Date) o.getCdeFinalContractualSettlementDate()))
				.put("cdeSettlementLocationLeg1", ExistenceChecker.isSet((String) o.getCdeSettlementLocationLeg1()))
				.put("cdeSettlementLocationLeg2", ExistenceChecker.isSet((String) o.getCdeSettlementLocationLeg2()))
				.put("cdeEffectiveDate", ExistenceChecker.isSet((Date) o.getCdeEffectiveDate()))
				.put("cdeExpirationDate", ExistenceChecker.isSet((Date) o.getCdeExpirationDate()))
				.put("cdePlatformIdentifier", ExistenceChecker.isSet((String) o.getCdePlatformIdentifier()))
				.put("primeBrokerageTransactionIndicator", ExistenceChecker.isSet((Boolean) o.getPrimeBrokerageTransactionIndicator()))
				.put("swapReportingJurisdiction", ExistenceChecker.isSet((String) o.getSwapReportingJurisdiction()))
				.put("newSdrIdentifier", ExistenceChecker.isSet((String) o.getNewSdrIdentifier()))
				.put("nextFloatingReferenceResetDateLeg1", ExistenceChecker.isSet((Date) o.getNextFloatingReferenceResetDateLeg1()))
				.put("lastFloatingReferenceValueLeg1", ExistenceChecker.isSet((BigDecimal) o.getLastFloatingReferenceValueLeg1()))
				.put("lastFloatingReferenceResetDateLeg1", ExistenceChecker.isSet((Date) o.getLastFloatingReferenceResetDateLeg1()))
				.put("nextFloatingReferenceResetDateLeg2", ExistenceChecker.isSet((Date) o.getNextFloatingReferenceResetDateLeg2()))
				.put("lastFloatingReferenceValueLeg2", ExistenceChecker.isSet((BigDecimal) o.getLastFloatingReferenceValueLeg2()))
				.put("lastFloatingReferenceResetDateLeg2", ExistenceChecker.isSet((Date) o.getLastFloatingReferenceResetDateLeg2()))
				.put("cdeDelta", ExistenceChecker.isSet((BigDecimal) o.getCdeDelta()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("largeNotionalOffFacilitySwapElectionIndicator", ExistenceChecker.isSet((Boolean) o.getLargeNotionalOffFacilitySwapElectionIndicator()))
				.put("sefOrDcmAnonymousExecutionIndicator", ExistenceChecker.isSet((Boolean) o.getSefOrDcmAnonymousExecutionIndicator()))
				.put("blockTradeElectionIndicator", ExistenceChecker.isSet((Boolean) o.getBlockTradeElectionIndicator()))
				.put("sefOrDcmIndicator", ExistenceChecker.isSet((Boolean) o.getSefOrDcmIndicator()))
				.put("mandatoryClearingIndicator", ExistenceChecker.isSet((Boolean) o.getMandatoryClearingIndicator()))
				.put("sdMspIndicatorCounterparty1", ExistenceChecker.isSet((Boolean) o.getSdMspIndicatorCounterparty1()))
				.put("sdMspIndicatorCounterparty2", ExistenceChecker.isSet((Boolean) o.getSdMspIndicatorCounterparty2()))
				.put("physicalCommodityContractIndicator", ExistenceChecker.isSet((Boolean) o.getPhysicalCommodityContractIndicator()))
				.put("changeInNotionalAmount1", ExistenceChecker.isSet((BigDecimal) o.getChangeInNotionalAmount1()))
				.put("changeInNotionalAmount2", ExistenceChecker.isSet((BigDecimal) o.getChangeInNotionalAmount2()))
				.put("changeInLeg1NotionalQuantity", ExistenceChecker.isSet((BigDecimal) o.getChangeInLeg1NotionalQuantity()))
				.put("changeInLeg2NotionalQuantity", ExistenceChecker.isSet((BigDecimal) o.getChangeInLeg2NotionalQuantity()))
				.put("cdeCryptoAssetUnderlyingIndicatorLeg1", ExistenceChecker.isSet((Boolean) o.getCdeCryptoAssetUnderlyingIndicatorLeg1()))
				.put("cdeCryptoAssetUnderlyingIndicatorLeg2", ExistenceChecker.isSet((Boolean) o.getCdeCryptoAssetUnderlyingIndicatorLeg2()))
				.put("cdeCustomBasketCode", ExistenceChecker.isSet((String) o.getCdeCustomBasketCode()))
				.put("underlierIdOtherLeg1", ExistenceChecker.isSet((String) o.getUnderlierIdOtherLeg1()))
				.put("underlierIdOtherLeg2", ExistenceChecker.isSet((String) o.getUnderlierIdOtherLeg2()))
				.put("underlierIdOtherSourceLeg1", ExistenceChecker.isSet((String) o.getUnderlierIdOtherSourceLeg1()))
				.put("underlierIdOtherSourceLeg2", ExistenceChecker.isSet((String) o.getUnderlierIdOtherSourceLeg2()))
				.put("cdeUnderlyingAssetTradingPlatformIdLeg1", ExistenceChecker.isSet((String) o.getCdeUnderlyingAssetTradingPlatformIdLeg1()))
				.put("cdeUnderlyingAssetTradingPlatformIdLeg2", ExistenceChecker.isSet((String) o.getCdeUnderlyingAssetTradingPlatformIdLeg2()))
				.put("cdeUnderlyingAssetPriceSourceLeg1", ExistenceChecker.isSet((String) o.getCdeUnderlyingAssetPriceSourceLeg1()))
				.put("cdeUnderlyingAssetPriceSourceLeg2", ExistenceChecker.isSet((String) o.getCdeUnderlyingAssetPriceSourceLeg2()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("HarmonizedData", ValidationResult.ValidationType.ONLY_EXISTS, "HarmonizedData", path, "");
		}
		return failure("HarmonizedData", ValidationResult.ValidationType.ONLY_EXISTS, "HarmonizedData", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
