package org.isda.drr.example.reporting.collateralmargin;

import com.regnosys.rosetta.common.validation.ValidationReport;
import drr.regulation.cftc.rewrite.margin.CFTCMarginReport;
import drr.regulation.cftc.rewrite.margin.reports.CFTCMarginReportFunction;
import jakarta.inject.Inject;
import org.isda.drr.example.AbstractReportingTest;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate CFTC collateral reporting without projection.
 * This class validates the transformation of a `CollateralReportInstruction` to a `CFTCMarginReport`,
 * followed by validation.
 */
final class CFTCCollateralWithoutProjectionTest extends AbstractReportingTest {

    // Function to generate a CFTC Margin Report from a CollateralReportInstruction
    @Inject
    CFTCMarginReportFunction reportFunc;

    /**
     * Demonstrates CFTC collateral reporting without projection.
     * The test performs the following steps:
     * - Loads a `CollateralReportInstruction` from JSON.
     * - Generates a `CFTCMarginReport` and validates it.
     *
     * @throws IOException If there is an error during file reading or processing.
     */
    @Test
    void CFTCCollateralWithoutProjectionExampleTest() throws IOException {

        // Generate the CFTC margin report
        CFTCMarginReport report = runReport(collateralReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(CFTCMarginReport.class, report);
        ReportingTestUtils.printValidation(validationReport);
    }
}
