package org.isda.drr.example.reporting.collateralmargin;

import jakarta.inject.Inject;
import com.regnosys.rosetta.common.validation.ValidationReport;
import drr.regulation.csa.rewrite.margin.CSAMarginReport;
import drr.regulation.csa.rewrite.margin.reports.CSAMarginReportFunction;
import org.isda.drr.example.AbstractReportingTest;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate CSA collateral reporting without projection.
 * This class validates the transformation of a `CollateralReportInstruction` to a `CSAMarginReport`,
 * followed by validation.
 */
final class CSACollateralWithoutProjectionTest extends AbstractReportingTest {

    // Function to generate a CSA Margin Report from a CollateralReportInstruction
    @Inject
    CSAMarginReportFunction reportFunc;

    /**
     * Demonstrates CSA collateral reporting without projection.
     * The test performs the following steps:
     * - Loads a `CollateralReportInstruction` from JSON.
     * - Generates a `CSAMarginReport` and validates it.
     *
     * @throws IOException If there is an error during file reading or processing.
     */
    @Test
    void CSACollateralWithoutProjectionExampleTest() throws IOException {

        // Generate the CSA margin report
        CSAMarginReport report = runReport(collateralReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(CSAMarginReport.class, report);
        ReportingTestUtils.printValidation(validationReport);
    }
}
