package org.isda.drr.example.reporting.transaction;

import drr.projection.dtcc.rds.harmonized.cftc.rewrite.trade.functions.Project_CftcPart43TradeReportToDtccRdsHarmonized;
import iso20022.DtccRdsHarmonizedModelConfig;
import jakarta.inject.Inject;
import com.regnosys.rosetta.common.validation.ValidationReport;
import drr.regulation.cftc.rewrite.trade.CFTCPart43TransactionReport;
import drr.regulation.cftc.rewrite.trade.reports.CFTCPart43ReportFunction;
import org.isda.drr.example.AbstractReportingTest;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate CFTC Part 43 transaction reporting with dtcc rds projection.
 * This class validates the transformation of a `TransactionReportInstruction` to a `CFTCPart43TransactionReport`,
 * followed by validation of the generated report.
 */
final class CFTCPart43WithDtccProjectionTest extends AbstractReportingTest {

    // Function to generate a CFTC Part 43 Transaction Report
    @Inject
    CFTCPart43ReportFunction reportFunc;

    // Function to project an CFTC Part 43 Trade Report to Dtcc Rds Harmonized format
    @Inject
    Project_CftcPart43TradeReportToDtccRdsHarmonized cftcPart43TradeReportToDtccRdsHarmonized;

    /**
     * Demonstrates CFTC Part 43 transaction reporting with dtcc rds projection.
     * The test performs the following steps:
     * - Loads a `TransactionReportInstruction` from JSON.
     * - Generates a `CFTCPart43TransactionReport` and validates it.
     *
     * @throws IOException If there is an error during file reading or processing.
     */
    @Test
    void CFTCPart43WithDtccRdsProjectionExampleReportTest() throws IOException {

        // Generate the CFTC Part 43 transaction report
        CFTCPart43TransactionReport report = runReport(transactionReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(CFTCPart43TransactionReport.class, report);
        ReportingTestUtils.printValidation(validationReport);

        // Project the report to Dtcc Rds Harmonized format
        projectReport(report, cftcPart43TradeReportToDtccRdsHarmonized::evaluate, DtccRdsHarmonizedModelConfig.XML_CONFIG_PATH);
    }
}
