package org.isda.drr.example.reporting.transaction;

import drr.projection.dtcc.rds.harmonized.cftc.rewrite.trade.functions.Project_CftcPart45TradeReportToDtccRdsHarmonized;
import drr.regulation.cftc.rewrite.trade.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.trade.reports.CFTCPart45ReportFunction;
import org.isda.drr.example.AbstractReportingTest;
import iso20022.DtccRdsHarmonizedModelConfig;
import jakarta.inject.Inject;
import com.regnosys.rosetta.common.validation.ValidationReport;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate CFTC Part 45 transaction reporting with dtcc rds projection.
 * This class validates the transformation of a `TransactionReportInstruction` to a `CFTCPart45TransactionReport`,
 * followed by validation of the generated report.
 */
final class CFTCPart45WithDtccProjectionTest extends AbstractReportingTest {

    // Function to generate a CFTC Part 45 Transaction Report
    @Inject
    CFTCPart45ReportFunction reportFunc;

    // Function to project an CFTC Part 45 Trade Report to Dtcc Rds Harmonized format
    @Inject
    Project_CftcPart45TradeReportToDtccRdsHarmonized cftcPart45TradeReportToDtccRdsHarmonized;

    /**
     * Demonstrates CFTC Part 45 transaction reporting with dtcc rds projection.
     * The test performs the following steps:
     * - Loads a `TransactionReportInstruction` from JSON.
     * - Generates a `CFTCPart45TransactionReport` and validates it.
     *
     * @throws IOException If there is an error during file reading or processing.
     */
    @Test
    void CFTCPart45WithDtccRdsProjectionExampleReportTest() throws IOException {

        // Generate the CFTC Part 45 transaction report
        CFTCPart45TransactionReport report = runReport(transactionReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(CFTCPart45TransactionReport.class, report);
        ReportingTestUtils.printValidation(validationReport);

        // Project the report to Dtcc Rds Harmonized format
        projectReport(report, cftcPart45TradeReportToDtccRdsHarmonized::evaluate, DtccRdsHarmonizedModelConfig.XML_CONFIG_PATH);
    }
}
