package org.isda.drr.example.reporting.transaction;

import jakarta.inject.Inject;
import com.regnosys.rosetta.common.validation.ValidationReport;
import drr.projection.dtcc.rds.harmonized.csa.rewrite.trade.functions.Project_CSATradeReportToDtccRdsHarmonized;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.regulation.csa.rewrite.trade.reports.CSATradeReportFunction;
import iso20022.DtccRdsHarmonizedModelConfig;
import org.isda.drr.example.AbstractReportingTest;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate CSA transaction reporting with Dtcc projection.
 * This class validates the transformation of a `TransactionReportInstruction` to a `CSATransactionReport`,
 * followed by validation and Dtcc projection.
 */
final class CSATradeWithDtccProjectionTest extends AbstractReportingTest {

    // Function to generate a CSA Transaction Report
    @Inject
    CSATradeReportFunction reportFunc;

    // Function to project a CSA transaction report to Dtcc Rds Harmonized format
    @Inject
    Project_CSATradeReportToDtccRdsHarmonized csaTradeReportToDtccRdsHarmonized;

    /**
     * Demonstrates CSA transaction reporting with Dtcc Rds projection.
     * The test performs the following steps:
     * - Loads a `TransactionReportInstruction` from JSON.
     * - Generates a `CSATransactionReport` and validates it.
     * - Projects the report to Dtcc Rds format.
     *
     * @throws IOException If there is an error during file reading or processing.
     */
    @Test
    void CSATradeWithDtccRdsProjectionExampleReportTest() throws IOException {

        // Generate the CSA transaction report
        CSATransactionReport report = runReport(transactionReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(CSATransactionReport.class, report);
        ReportingTestUtils.printValidation(validationReport);

        // Project the report to Dtcc Rds Harmonized format
        projectReport(report, csaTradeReportToDtccRdsHarmonized::evaluate, DtccRdsHarmonizedModelConfig.XML_CONFIG_PATH);
    }
}
