package org.isda.drr.example.reporting.valuation;

import com.regnosys.rosetta.common.validation.ValidationReport;
import drr.projection.dtcc.rds.harmonized.cftc.rewrite.valuation.functions.Project_CFTCValuationReportToDtccRdsHarmonized;
import drr.regulation.cftc.rewrite.valuation.CFTCValuationReport;
import drr.regulation.cftc.rewrite.valuation.reports.CFTCValuationReportFunction;
import iso20022.DtccRdsHarmonizedModelConfig;
import jakarta.inject.Inject;
import org.isda.drr.example.AbstractReportingTest;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate CFTC valuation reporting with Dtcc projection.
 * The test validates the transformation of a `ValuationReportInstruction` to an `CFTCValuationReport`,
 * followed by validation and Dtcc projection.
 */
final class CFTCValuationWithDtccProjectionTest extends AbstractReportingTest {

    // Function to generate a CFTCValuationReport from a ValuationReportInstruction.
    @Inject
    CFTCValuationReportFunction reportFunc;

    // Function to project a CFTC valuation report to Dtcc Rds Harmonized format
    @Inject
    Project_CFTCValuationReportToDtccRdsHarmonized cftcValuationReportToDtccRdsHarmonized;


    /**
     * Demonstrates CFTC valuation reporting with Dtcc Rds projection.
     * The test performs the following steps:
     * - Loads a `ValuationReportInstruction` from JSON.
     * - Generates a `CFTCValuationReport` and validates it.
     * - Projects the report to Dtcc Rds format.
     *
     * @throws IOException If there is an error during file reading or processing.
     */
    @Test
    void CFTCValuationWithDtccRdsProjectionExampleReportTest() throws IOException {

        // Generate the CFTC valuation report
        CFTCValuationReport report = runReport(valuationReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(CFTCValuationReport.class, report);
        ReportingTestUtils.printValidation(validationReport);

        // project the report to Dtcc Rds Harmonized format
        projectReport(report, cftcValuationReportToDtccRdsHarmonized::evaluate, DtccRdsHarmonizedModelConfig.XML_CONFIG_PATH);
    }
}
