package org.isda.drr.example.reporting.valuation;

import jakarta.inject.Inject;
import com.regnosys.rosetta.common.validation.ValidationReport;
import drr.projection.dtcc.rds.harmonized.csa.rewrite.valuation.functions.Project_CSAValuationReportToDtccRdsHarmonized;
import drr.regulation.csa.rewrite.valuation.CSAValuationReport;
import drr.regulation.csa.rewrite.valuation.reports.CSAValuationReportFunction;
import iso20022.DtccRdsHarmonizedModelConfig;
import org.isda.drr.example.AbstractReportingTest;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate CSA valuation reporting with Dtcc projection.
 * The test validates the transformation of a `ValuationReportInstruction` to an `CSAValuationReport`,
 * followed by validation and Dtcc projection.
 */
final class CSAValuationWithDtccProjectionTest extends AbstractReportingTest {

    // Function to generate a CSAValuationReport from a ValuationReportInstruction.
    @Inject
    CSAValuationReportFunction reportFunc;

    // Function to project a CSA valuation report to Dtcc Rds Harmonized format
    @Inject
    Project_CSAValuationReportToDtccRdsHarmonized csaValuationReportToDtccRdsHarmonized;


    /**
     * Demonstrates CSA valuation reporting with Dtcc Rds projection.
     * The test performs the following steps:
     * - Loads a `ValuationReportInstruction` from JSON.
     * - Generates a `CSAValuationReport` and validates it.
     * - Projects the report to Dtcc Rds format.
     *
     * @throws IOException If there is an error during file reading or processing.
     */
    @Test
    void CSATradeWithDtccRdsProjectionExampleReportTest() throws IOException {

        // Generate the CSA valuation report
        CSAValuationReport report = runReport(valuationReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(CSAValuationReport.class, report);
        ReportingTestUtils.printValidation(validationReport);

        // Project the report to Dtcc Rds Harmonized format
        projectReport(report, csaValuationReportToDtccRdsHarmonized::evaluate, DtccRdsHarmonizedModelConfig.XML_CONFIG_PATH);
    }
}
