package org.isda.drr.example.reporting.valuation;

import drr.regulation.jfsa.rewrite.valuation.JFSAValuationReport;
import drr.regulation.jfsa.rewrite.valuation.reports.JFSAValuationReportFunction;
import jakarta.inject.Inject;
import com.regnosys.rosetta.common.validation.ValidationReport;
import org.isda.drr.example.AbstractReportingTest;
import org.isda.drr.example.util.ReportingTestUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;

import static org.junit.jupiter.api.Assertions.assertNotNull;

/**
 * Test class to demonstrate JFSA valuation reporting without projection.
 * The test validates the transformation of a `ValuationReportInstruction` to a `JFSAValuationReport`,
 * followed by validation.
 */
final class JFSAValuationWithoutProjectionTest extends AbstractReportingTest {

    // Function to generate a JFSAValuationReport from a ValuationReportInstruction.
    @Inject
    JFSAValuationReportFunction reportFunc;

    /**
     * Demonstrates JFSA valuation reporting without projection.
     * The test performs the following steps:
     * - Loads a `ValuationReportInstruction` from JSON.
     * - Generates an `JFSAValuationReport` and validates it.
     *
     * @throws IOException If there is an error during file reading or writing.
     */
    @Test
    void JFSAValuationWithoutProjectionExampleTest() throws IOException {

        // Generate the JFSA valuation report
        JFSAValuationReport report = runReport(valuationReportInstruction, reportFunc::evaluate);
        assertNotNull(report, "The report is null");

        // Validate the report and print validation results
        ValidationReport validationReport = validator.runProcessStep(JFSAValuationReport.class, report);
        ReportingTestUtils.printValidation(validationReport);
    }
}

